package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TokenReviewStatusBuilder extends TokenReviewStatusFluentImpl<TokenReviewStatusBuilder> implements VisitableBuilder<TokenReviewStatus,TokenReviewStatusBuilder> {

    TokenReviewStatusFluent<?> fluent;
    Boolean validationEnabled;

    public TokenReviewStatusBuilder() {
        this(true);
    }

    public TokenReviewStatusBuilder(Boolean validationEnabled) {
        this(new TokenReviewStatus(), validationEnabled);
    }

    public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new TokenReviewStatus(), validationEnabled);
    }

    public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent,TokenReviewStatus instance) {
        this(fluent, instance, true);
    }

    public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent,TokenReviewStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAudiences(instance.getAudiences()); 
        fluent.withAuthenticated(instance.getAuthenticated()); 
        fluent.withError(instance.getError()); 
        fluent.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public TokenReviewStatusBuilder(TokenReviewStatus instance) {
        this(instance,true);
    }

    public TokenReviewStatusBuilder(TokenReviewStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAudiences(instance.getAudiences()); 
        this.withAuthenticated(instance.getAuthenticated()); 
        this.withError(instance.getError()); 
        this.withUser(instance.getUser()); 
        this.validationEnabled = validationEnabled; 
    }

    public TokenReviewStatus build() {
        TokenReviewStatus buildable = new TokenReviewStatus(fluent.getAudiences(),fluent.getAuthenticated(),fluent.getError(),fluent.getUser());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TokenReviewStatusBuilder that = (TokenReviewStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
