package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SelfSubjectAccessReviewBuilder extends SelfSubjectAccessReviewFluentImpl<SelfSubjectAccessReviewBuilder> implements VisitableBuilder<SelfSubjectAccessReview,SelfSubjectAccessReviewBuilder> {

    SelfSubjectAccessReviewFluent<?> fluent;
    Boolean validationEnabled;

    public SelfSubjectAccessReviewBuilder() {
        this(true);
    }

    public SelfSubjectAccessReviewBuilder(Boolean validationEnabled) {
        this(new SelfSubjectAccessReview(), validationEnabled);
    }

    public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReviewFluent<?> fluent) {
        this(fluent, true);
    }

    public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReviewFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SelfSubjectAccessReview(), validationEnabled);
    }

    public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReviewFluent<?> fluent,SelfSubjectAccessReview instance) {
        this(fluent, instance, true);
    }

    public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReviewFluent<?> fluent,SelfSubjectAccessReview instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReview instance) {
        this(instance,true);
    }

    public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReview instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public SelfSubjectAccessReview build() {
        SelfSubjectAccessReview buildable = new SelfSubjectAccessReview(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SelfSubjectAccessReviewBuilder that = (SelfSubjectAccessReviewBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
