package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MutatingWebhookBuilder extends io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookFluentImpl<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhook,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookBuilder> {

    io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookFluent<?> fluent;
    Boolean validationEnabled;

    public MutatingWebhookBuilder() {
        this(true);
    }

    public MutatingWebhookBuilder(Boolean validationEnabled) {
        this(new MutatingWebhook(), validationEnabled);
    }

    public MutatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookFluent<?> fluent) {
        this(fluent, true);
    }

    public MutatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new MutatingWebhook(), validationEnabled);
    }

    public MutatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhook instance) {
        this(fluent, instance, true);
    }

    public MutatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhook instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAdmissionReviewVersions(instance.getAdmissionReviewVersions()); 
        fluent.withClientConfig(instance.getClientConfig()); 
        fluent.withFailurePolicy(instance.getFailurePolicy()); 
        fluent.withMatchPolicy(instance.getMatchPolicy()); 
        fluent.withName(instance.getName()); 
        fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
        fluent.withObjectSelector(instance.getObjectSelector()); 
        fluent.withReinvocationPolicy(instance.getReinvocationPolicy()); 
        fluent.withRules(instance.getRules()); 
        fluent.withSideEffects(instance.getSideEffects()); 
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public MutatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhook instance) {
        this(instance,true);
    }

    public MutatingWebhookBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhook instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions()); 
        this.withClientConfig(instance.getClientConfig()); 
        this.withFailurePolicy(instance.getFailurePolicy()); 
        this.withMatchPolicy(instance.getMatchPolicy()); 
        this.withName(instance.getName()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withObjectSelector(instance.getObjectSelector()); 
        this.withReinvocationPolicy(instance.getReinvocationPolicy()); 
        this.withRules(instance.getRules()); 
        this.withSideEffects(instance.getSideEffects()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhook build() {
        MutatingWebhook buildable = new MutatingWebhook(fluent.getAdmissionReviewVersions(),fluent.getClientConfig(),fluent.getFailurePolicy(),fluent.getMatchPolicy(),fluent.getName(),fluent.getNamespaceSelector(),fluent.getObjectSelector(),fluent.getReinvocationPolicy(),fluent.getRules(),fluent.getSideEffects(),fluent.getTimeoutSeconds());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MutatingWebhookBuilder that = (MutatingWebhookBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
