package io.fabric8.kubernetes.api.model.authorization.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class SelfSubjectRulesReviewFluentImpl<A extends SelfSubjectRulesReviewFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SelfSubjectRulesReviewFluent<A> {

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private SelfSubjectRulesReviewSpecBuilder spec;
    private SubjectRulesReviewStatusBuilder status;

    public SelfSubjectRulesReviewFluentImpl() {
    }

    public SelfSubjectRulesReviewFluentImpl(SelfSubjectRulesReview instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public SelfSubjectRulesReviewSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public SelfSubjectRulesReviewSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(SelfSubjectRulesReviewSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new SelfSubjectRulesReviewSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public A withNewSpec(String namespace) {
        return (A)withSpec(new SelfSubjectRulesReviewSpec(namespace));
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.SpecNested<A> withNewSpecLike(SelfSubjectRulesReviewSpec item) {
        return new SpecNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new SelfSubjectRulesReviewSpecBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.SpecNested<A> editOrNewSpecLike(SelfSubjectRulesReviewSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public SubjectRulesReviewStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public SubjectRulesReviewStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(SubjectRulesReviewStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new SubjectRulesReviewStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.StatusNested<A> withNewStatusLike(SubjectRulesReviewStatus item) {
        return new StatusNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new SubjectRulesReviewStatusBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.StatusNested<A> editOrNewStatusLike(SubjectRulesReviewStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SelfSubjectRulesReviewFluentImpl that = (SelfSubjectRulesReviewFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) SelfSubjectRulesReviewFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SpecNestedImpl<N> extends SelfSubjectRulesReviewSpecFluentImpl<io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.SpecNested<N>> implements io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SelfSubjectRulesReviewSpecBuilder builder;

            SpecNestedImpl(SelfSubjectRulesReviewSpec item) {
                this.builder = new SelfSubjectRulesReviewSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new SelfSubjectRulesReviewSpecBuilder(this);
                        
            }

            public N and() {
                return (N) SelfSubjectRulesReviewFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends SubjectRulesReviewStatusFluentImpl<io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.StatusNested<N>> implements io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectRulesReviewFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SubjectRulesReviewStatusBuilder builder;

            StatusNestedImpl(SubjectRulesReviewStatus item) {
                this.builder = new SubjectRulesReviewStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new SubjectRulesReviewStatusBuilder(this);
                        
            }

            public N and() {
                return (N) SelfSubjectRulesReviewFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
