package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubjectAccessReviewBuilder extends SubjectAccessReviewFluentImpl<SubjectAccessReviewBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<SubjectAccessReview,SubjectAccessReviewBuilder> {

    SubjectAccessReviewFluent<?> fluent;
    Boolean validationEnabled;

    public SubjectAccessReviewBuilder() {
        this(true);
    }

    public SubjectAccessReviewBuilder(Boolean validationEnabled) {
        this(new SubjectAccessReview(), validationEnabled);
    }

    public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent) {
        this(fluent, true);
    }

    public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SubjectAccessReview(), validationEnabled);
    }

    public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,SubjectAccessReview instance) {
        this(fluent, instance, true);
    }

    public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,SubjectAccessReview instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public SubjectAccessReviewBuilder(SubjectAccessReview instance) {
        this(instance,true);
    }

    public SubjectAccessReviewBuilder(SubjectAccessReview instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public SubjectAccessReview build() {
        SubjectAccessReview buildable = new SubjectAccessReview(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SubjectAccessReviewBuilder that = (SubjectAccessReviewBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
