package io.fabric8.kubernetes.api.model.admission.v1beta1;

import io.fabric8.kubernetes.api.model.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class AdmissionResponseFluentImpl<A extends io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseFluent<A> {

    private Boolean allowed;
    private java.util.Map<String,String> auditAnnotations;
    private String patch;
    private String patchType;
    private Status status;
    private String uid;
    private List<String> warnings = new ArrayList<String>();

    public AdmissionResponseFluentImpl() {
    }

    public AdmissionResponseFluentImpl(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse instance) {
        this.withAllowed(instance.getAllowed()); 
        this.withAuditAnnotations(instance.getAuditAnnotations()); 
        this.withPatch(instance.getPatch()); 
        this.withPatchType(instance.getPatchType()); 
        this.withStatus(instance.getStatus()); 
        this.withUid(instance.getUid()); 
        this.withWarnings(instance.getWarnings()); 
    }

    public Boolean getAllowed() {
        return this.allowed;
    }

    public A withAllowed(Boolean allowed) {
        this.allowed=allowed; return (A) this;
    }

    public Boolean hasAllowed() {
        return this.allowed != null;
    }

    public A withNewAllowed(String arg1) {
        return (A)withAllowed(new Boolean(arg1));
    }

    public A withNewAllowed(boolean arg1) {
        return (A)withAllowed(new Boolean(arg1));
    }

    public A addToAuditAnnotations(String key,String value) {
        if(this.auditAnnotations == null && key != null && value != null) { this.auditAnnotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.auditAnnotations.put(key, value);} return (A)this;
    }

    public A addToAuditAnnotations(java.util.Map<String,String> map) {
        if(this.auditAnnotations == null && map != null) { this.auditAnnotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.auditAnnotations.putAll(map);} return (A)this;
    }

    public A removeFromAuditAnnotations(String key) {
        if(this.auditAnnotations == null) { return (A) this; }
        if(key != null && this.auditAnnotations != null) {this.auditAnnotations.remove(key);} return (A)this;
    }

    public A removeFromAuditAnnotations(java.util.Map<String,String> map) {
        if(this.auditAnnotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.auditAnnotations != null){this.auditAnnotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getAuditAnnotations() {
        return this.auditAnnotations;
    }

    public <K extends Object,V extends Object>A withAuditAnnotations(java.util.Map<String,String> auditAnnotations) {
        if (auditAnnotations == null) { this.auditAnnotations =  null;} else {this.auditAnnotations = new LinkedHashMap<String,String>(auditAnnotations);} return (A) this;
    }

    public Boolean hasAuditAnnotations() {
        return this.auditAnnotations != null;
    }

    public String getPatch() {
        return this.patch;
    }

    public A withPatch(String patch) {
        this.patch=patch; return (A) this;
    }

    public Boolean hasPatch() {
        return this.patch != null;
    }

    public A withNewPatch(StringBuilder arg1) {
        return (A)withPatch(new String(arg1));
    }

    public A withNewPatch(int[] arg1,int arg2,int arg3) {
        return (A)withPatch(new String(arg1, arg2, arg3));
    }

    public A withNewPatch(char[] arg1) {
        return (A)withPatch(new String(arg1));
    }

    public A withNewPatch(StringBuffer arg1) {
        return (A)withPatch(new String(arg1));
    }

    public A withNewPatch(byte[] arg1,int arg2) {
        return (A)withPatch(new String(arg1, arg2));
    }

    public A withNewPatch(byte[] arg1) {
        return (A)withPatch(new String(arg1));
    }

    public A withNewPatch(char[] arg1,int arg2,int arg3) {
        return (A)withPatch(new String(arg1, arg2, arg3));
    }

    public A withNewPatch(byte[] arg1,int arg2,int arg3) {
        return (A)withPatch(new String(arg1, arg2, arg3));
    }

    public A withNewPatch(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPatch(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPatch(String arg1) {
        return (A)withPatch(new String(arg1));
    }

    public String getPatchType() {
        return this.patchType;
    }

    public A withPatchType(String patchType) {
        this.patchType=patchType; return (A) this;
    }

    public Boolean hasPatchType() {
        return this.patchType != null;
    }

    public A withNewPatchType(StringBuilder arg1) {
        return (A)withPatchType(new String(arg1));
    }

    public A withNewPatchType(int[] arg1,int arg2,int arg3) {
        return (A)withPatchType(new String(arg1, arg2, arg3));
    }

    public A withNewPatchType(char[] arg1) {
        return (A)withPatchType(new String(arg1));
    }

    public A withNewPatchType(StringBuffer arg1) {
        return (A)withPatchType(new String(arg1));
    }

    public A withNewPatchType(byte[] arg1,int arg2) {
        return (A)withPatchType(new String(arg1, arg2));
    }

    public A withNewPatchType(byte[] arg1) {
        return (A)withPatchType(new String(arg1));
    }

    public A withNewPatchType(char[] arg1,int arg2,int arg3) {
        return (A)withPatchType(new String(arg1, arg2, arg3));
    }

    public A withNewPatchType(byte[] arg1,int arg2,int arg3) {
        return (A)withPatchType(new String(arg1, arg2, arg3));
    }

    public A withNewPatchType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPatchType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPatchType(String arg1) {
        return (A)withPatchType(new String(arg1));
    }

    public Status getStatus() {
        return this.status;
    }

    public A withStatus(Status status) {
        this.status=status; return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid=uid; return (A) this;
    }

    public Boolean hasUid() {
        return this.uid != null;
    }

    public A withNewUid(StringBuilder arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(int[] arg1,int arg2,int arg3) {
        return (A)withUid(new String(arg1, arg2, arg3));
    }

    public A withNewUid(char[] arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(byte[] arg1,int arg2) {
        return (A)withUid(new String(arg1, arg2));
    }

    public A withNewUid(byte[] arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(char[] arg1,int arg2,int arg3) {
        return (A)withUid(new String(arg1, arg2, arg3));
    }

    public A withNewUid(byte[] arg1,int arg2,int arg3) {
        return (A)withUid(new String(arg1, arg2, arg3));
    }

    public A withNewUid(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUid(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUid(String arg1) {
        return (A)withUid(new String(arg1));
    }

    public A addToWarnings(int index,String item) {
        if (this.warnings == null) {this.warnings = new ArrayList<String>();}
        this.warnings.add(index, item);
        return (A)this;
    }

    public A setToWarnings(int index,String item) {
        if (this.warnings == null) {this.warnings = new ArrayList<String>();}
        this.warnings.set(index, item); return (A)this;
    }

    public A addToWarnings(String... items) {
        if (this.warnings == null) {this.warnings = new ArrayList<String>();}
        for (String item : items) {this.warnings.add(item);} return (A)this;
    }

    public A addAllToWarnings(Collection<String> items) {
        if (this.warnings == null) {this.warnings = new ArrayList<String>();}
        for (String item : items) {this.warnings.add(item);} return (A)this;
    }

    public A removeFromWarnings(String... items) {
        for (String item : items) {if (this.warnings!= null){ this.warnings.remove(item);}} return (A)this;
    }

    public A removeAllFromWarnings(Collection<String> items) {
        for (String item : items) {if (this.warnings!= null){ this.warnings.remove(item);}} return (A)this;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public String getWarning(int index) {
        return this.warnings.get(index);
    }

    public String getFirstWarning() {
        return this.warnings.get(0);
    }

    public String getLastWarning() {
        return this.warnings.get(warnings.size() - 1);
    }

    public String getMatchingWarning(Predicate<String> predicate) {
        for (String item: warnings) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingWarning(Predicate<String> predicate) {
        for (String item: warnings) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withWarnings(List<String> warnings) {
        if (this.warnings != null) { _visitables.get("warnings").removeAll(this.warnings);}
        if (warnings != null) {this.warnings = new ArrayList<String>(); for (String item : warnings){this.addToWarnings(item);}} else { this.warnings = null;} return (A) this;
    }

    public A withWarnings(String... warnings) {
        if (this.warnings != null) {this.warnings.clear();}
        if (warnings != null) {for (String item :warnings){ this.addToWarnings(item);}} return (A) this;
    }

    public Boolean hasWarnings() {
        return warnings != null && !warnings.isEmpty();
    }

    public A addNewWarning(StringBuilder arg1) {
        return (A)addToWarnings(new String(arg1));
    }

    public A addNewWarning(int[] arg1,int arg2,int arg3) {
        return (A)addToWarnings(new String(arg1, arg2, arg3));
    }

    public A addNewWarning(char[] arg1) {
        return (A)addToWarnings(new String(arg1));
    }

    public A addNewWarning(StringBuffer arg1) {
        return (A)addToWarnings(new String(arg1));
    }

    public A addNewWarning(byte[] arg1,int arg2) {
        return (A)addToWarnings(new String(arg1, arg2));
    }

    public A addNewWarning(byte[] arg1) {
        return (A)addToWarnings(new String(arg1));
    }

    public A addNewWarning(char[] arg1,int arg2,int arg3) {
        return (A)addToWarnings(new String(arg1, arg2, arg3));
    }

    public A addNewWarning(byte[] arg1,int arg2,int arg3) {
        return (A)addToWarnings(new String(arg1, arg2, arg3));
    }

    public A addNewWarning(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToWarnings(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewWarning(String arg1) {
        return (A)addToWarnings(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdmissionResponseFluentImpl that = (AdmissionResponseFluentImpl) o;
        if (allowed != null ? !allowed.equals(that.allowed) :that.allowed != null) return false;
        if (auditAnnotations != null ? !auditAnnotations.equals(that.auditAnnotations) :that.auditAnnotations != null) return false;
        if (patch != null ? !patch.equals(that.patch) :that.patch != null) return false;
        if (patchType != null ? !patchType.equals(that.patchType) :that.patchType != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        if (warnings != null ? !warnings.equals(that.warnings) :that.warnings != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allowed,  auditAnnotations,  patch,  patchType,  status,  uid,  warnings,  super.hashCode());
    }

}
