package io.fabric8.kubernetes.api.model.admission.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class AdmissionReviewFluentImpl<A extends io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReviewFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReviewFluent<A> {

    private String apiVersion;
    private String kind;
    private io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionRequest request;
    private io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseBuilder response;

    public AdmissionReviewFluentImpl() {
    }

    public AdmissionReviewFluentImpl(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReview instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withRequest(instance.getRequest()); 
        this.withResponse(instance.getResponse()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionRequest getRequest() {
        return this.request;
    }

    public A withRequest(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionRequest request) {
        this.request=request; return (A) this;
    }

    public Boolean hasRequest() {
        return this.request != null;
    }

    
/**
 * This method has been deprecated, please use method buildResponse instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse getResponse() {
        return this.response!=null?this.response.build():null;
    }

    public io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse buildResponse() {
        return this.response!=null?this.response.build():null;
    }

    public A withResponse(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse response) {
        _visitables.get("response").remove(this.response);
        if (response!=null){ this.response= new io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseBuilder(response); _visitables.get("response").add(this.response);} return (A) this;
    }

    public Boolean hasResponse() {
        return this.response != null;
    }

    public io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReviewFluent.ResponseNested<A> withNewResponse() {
        return new ResponseNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReviewFluent.ResponseNested<A> withNewResponseLike(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse item) {
        return new ResponseNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReviewFluent.ResponseNested<A> editResponse() {
        return withNewResponseLike(getResponse());
    }

    public io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReviewFluent.ResponseNested<A> editOrNewResponse() {
        return withNewResponseLike(getResponse() != null ? getResponse(): new io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReviewFluent.ResponseNested<A> editOrNewResponseLike(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse item) {
        return withNewResponseLike(getResponse() != null ? getResponse(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdmissionReviewFluentImpl that = (AdmissionReviewFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (request != null ? !request.equals(that.request) :that.request != null) return false;
        if (response != null ? !response.equals(that.response) :that.response != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  request,  response,  super.hashCode());
    }

    public class ResponseNestedImpl<N> extends io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseFluentImpl<io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReviewFluent.ResponseNested<N>> implements io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionReviewFluent.ResponseNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseBuilder builder;

            ResponseNestedImpl(io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse item) {
                this.builder = new io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseBuilder(this, item);
                        
            }

            ResponseNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponseBuilder(this);
                        
            }

            public N and() {
                return (N) AdmissionReviewFluentImpl.this.withResponse(builder.build());
            }

            public N endResponse() {
                return and();
            }
    }


}
