package io.fabric8.kubernetes.api.model.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface TokenReviewStatusFluent<A extends TokenReviewStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToAudiences(int index,String item);
    public A setToAudiences(int index,String item);
    public A addToAudiences(String... items);
    public A addAllToAudiences(Collection<String> items);
    public A removeFromAudiences(String... items);
    public A removeAllFromAudiences(Collection<String> items);
    public List<String> getAudiences();
    public String getAudience(int index);
    public String getFirstAudience();
    public String getLastAudience();
    public String getMatchingAudience(Predicate<String> predicate);
    public Boolean hasMatchingAudience(Predicate<String> predicate);
    public A withAudiences(List<String> audiences);
    public A withAudiences(String... audiences);
    public Boolean hasAudiences();
    public A addNewAudience(StringBuilder arg1);
    public A addNewAudience(int[] arg1,int arg2,int arg3);
    public A addNewAudience(char[] arg1);
    public A addNewAudience(StringBuffer arg1);
    public A addNewAudience(byte[] arg1,int arg2);
    public A addNewAudience(byte[] arg1);
    public A addNewAudience(char[] arg1,int arg2,int arg3);
    public A addNewAudience(byte[] arg1,int arg2,int arg3);
    public A addNewAudience(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewAudience(String arg1);
    public Boolean getAuthenticated();
    public A withAuthenticated(Boolean authenticated);
    public Boolean hasAuthenticated();
    public A withNewAuthenticated(String arg1);
    public A withNewAuthenticated(boolean arg1);
    public String getError();
    public A withError(String error);
    public Boolean hasError();
    public A withNewError(StringBuilder arg1);
    public A withNewError(int[] arg1,int arg2,int arg3);
    public A withNewError(char[] arg1);
    public A withNewError(StringBuffer arg1);
    public A withNewError(byte[] arg1,int arg2);
    public A withNewError(byte[] arg1);
    public A withNewError(char[] arg1,int arg2,int arg3);
    public A withNewError(byte[] arg1,int arg2,int arg3);
    public A withNewError(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewError(String arg1);
    
/**
 * This method has been deprecated, please use method buildUser instead.
 * @return The buildable object.
 */
@Deprecated public UserInfo getUser();
    public UserInfo buildUser();
    public A withUser(UserInfo user);
    public Boolean hasUser();
    public io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<A> withNewUser();
    public io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<A> withNewUserLike(UserInfo item);
    public io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<A> editUser();
    public io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<A> editOrNewUser();
    public io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<A> editOrNewUserLike(UserInfo item);
    public interface UserNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UserInfoFluent<io.fabric8.kubernetes.api.model.authentication.TokenReviewStatusFluent.UserNested<N>> {

            public N and();
            public N endUser();    }


}
