package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class SubjectRulesReviewStatusFluentImpl<A extends SubjectRulesReviewStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubjectRulesReviewStatusFluent<A> {

    private String evaluationError;
    private Boolean incomplete;
    private List<NonResourceRuleBuilder> nonResourceRules =  new ArrayList<NonResourceRuleBuilder>();
    private List<ResourceRuleBuilder> resourceRules =  new ArrayList<ResourceRuleBuilder>();

    public SubjectRulesReviewStatusFluentImpl() {
    }

    public SubjectRulesReviewStatusFluentImpl(SubjectRulesReviewStatus instance) {
        this.withEvaluationError(instance.getEvaluationError()); 
        this.withIncomplete(instance.getIncomplete()); 
        this.withNonResourceRules(instance.getNonResourceRules()); 
        this.withResourceRules(instance.getResourceRules()); 
    }

    public String getEvaluationError() {
        return this.evaluationError;
    }

    public A withEvaluationError(String evaluationError) {
        this.evaluationError=evaluationError; return (A) this;
    }

    public Boolean hasEvaluationError() {
        return this.evaluationError != null;
    }

    public A withNewEvaluationError(StringBuilder arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public A withNewEvaluationError(int[] arg1,int arg2,int arg3) {
        return (A)withEvaluationError(new String(arg1, arg2, arg3));
    }

    public A withNewEvaluationError(char[] arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public A withNewEvaluationError(StringBuffer arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public A withNewEvaluationError(byte[] arg1,int arg2) {
        return (A)withEvaluationError(new String(arg1, arg2));
    }

    public A withNewEvaluationError(byte[] arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public A withNewEvaluationError(char[] arg1,int arg2,int arg3) {
        return (A)withEvaluationError(new String(arg1, arg2, arg3));
    }

    public A withNewEvaluationError(byte[] arg1,int arg2,int arg3) {
        return (A)withEvaluationError(new String(arg1, arg2, arg3));
    }

    public A withNewEvaluationError(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withEvaluationError(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewEvaluationError(String arg1) {
        return (A)withEvaluationError(new String(arg1));
    }

    public Boolean getIncomplete() {
        return this.incomplete;
    }

    public A withIncomplete(Boolean incomplete) {
        this.incomplete=incomplete; return (A) this;
    }

    public Boolean hasIncomplete() {
        return this.incomplete != null;
    }

    public A withNewIncomplete(String arg1) {
        return (A)withIncomplete(new Boolean(arg1));
    }

    public A withNewIncomplete(boolean arg1) {
        return (A)withIncomplete(new Boolean(arg1));
    }

    public A addToNonResourceRules(int index,NonResourceRule item) {
        if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<NonResourceRuleBuilder>();}
        NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").add(index >= 0 ? index : _visitables.get("nonResourceRules").size(), builder);this.nonResourceRules.add(index >= 0 ? index : nonResourceRules.size(), builder); return (A)this;
    }

    public A setToNonResourceRules(int index,NonResourceRule item) {
        if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<NonResourceRuleBuilder>();}
        NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
        if (index < 0 || index >= _visitables.get("nonResourceRules").size()) { _visitables.get("nonResourceRules").add(builder); } else { _visitables.get("nonResourceRules").set(index, builder);}
        if (index < 0 || index >= nonResourceRules.size()) { nonResourceRules.add(builder); } else { nonResourceRules.set(index, builder);}
         return (A)this;
    }

    public A addToNonResourceRules(NonResourceRule... items) {
        if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<NonResourceRuleBuilder>();}
        for (NonResourceRule item : items) {NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").add(builder);this.nonResourceRules.add(builder);} return (A)this;
    }

    public A addAllToNonResourceRules(Collection<NonResourceRule> items) {
        if (this.nonResourceRules == null) {this.nonResourceRules = new ArrayList<NonResourceRuleBuilder>();}
        for (NonResourceRule item : items) {NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").add(builder);this.nonResourceRules.add(builder);} return (A)this;
    }

    public A removeFromNonResourceRules(NonResourceRule... items) {
        for (NonResourceRule item : items) {NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").remove(builder);if (this.nonResourceRules != null) {this.nonResourceRules.remove(builder);}} return (A)this;
    }

    public A removeAllFromNonResourceRules(Collection<NonResourceRule> items) {
        for (NonResourceRule item : items) {NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").remove(builder);if (this.nonResourceRules != null) {this.nonResourceRules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromNonResourceRules(Predicate<NonResourceRuleBuilder> predicate) {
        if (nonResourceRules == null) return (A) this;
        final Iterator<NonResourceRuleBuilder> each = nonResourceRules.iterator();
        final List visitables = _visitables.get("nonResourceRules");
        while (each.hasNext()) {
          NonResourceRuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildNonResourceRules instead.
 * @return The buildable object.
 */
@Deprecated public List<NonResourceRule> getNonResourceRules() {
        return build(nonResourceRules);
    }

    public List<NonResourceRule> buildNonResourceRules() {
        return build(nonResourceRules);
    }

    public NonResourceRule buildNonResourceRule(int index) {
        return this.nonResourceRules.get(index).build();
    }

    public NonResourceRule buildFirstNonResourceRule() {
        return this.nonResourceRules.get(0).build();
    }

    public NonResourceRule buildLastNonResourceRule() {
        return this.nonResourceRules.get(nonResourceRules.size() - 1).build();
    }

    public NonResourceRule buildMatchingNonResourceRule(Predicate<NonResourceRuleBuilder> predicate) {
        for (NonResourceRuleBuilder item: nonResourceRules) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingNonResourceRule(Predicate<NonResourceRuleBuilder> predicate) {
        for (NonResourceRuleBuilder item: nonResourceRules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNonResourceRules(List<NonResourceRule> nonResourceRules) {
        if (this.nonResourceRules != null) { _visitables.get("nonResourceRules").removeAll(this.nonResourceRules);}
        if (nonResourceRules != null) {this.nonResourceRules = new ArrayList<NonResourceRuleBuilder>(); for (NonResourceRule item : nonResourceRules){this.addToNonResourceRules(item);}} else { this.nonResourceRules = null;} return (A) this;
    }

    public A withNonResourceRules(NonResourceRule... nonResourceRules) {
        if (this.nonResourceRules != null) {this.nonResourceRules.clear();}
        if (nonResourceRules != null) {for (NonResourceRule item :nonResourceRules){ this.addToNonResourceRules(item);}} return (A) this;
    }

    public Boolean hasNonResourceRules() {
        return nonResourceRules != null && !nonResourceRules.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRule() {
        return new NonResourceRulesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRuleLike(NonResourceRule item) {
        return new NonResourceRulesNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> setNewNonResourceRuleLike(int index,NonResourceRule item) {
        return new NonResourceRulesNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editNonResourceRule(int index) {
        if (nonResourceRules.size() <= index) throw new RuntimeException("Can't edit nonResourceRules. Index exceeds size.");
        return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editFirstNonResourceRule() {
        if (nonResourceRules.size() == 0) throw new RuntimeException("Can't edit first nonResourceRules. The list is empty.");
        return setNewNonResourceRuleLike(0, buildNonResourceRule(0));
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editLastNonResourceRule() {
        int index = nonResourceRules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last nonResourceRules. The list is empty.");
        return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editMatchingNonResourceRule(Predicate<NonResourceRuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<nonResourceRules.size();i++) { 
        if (predicate.test(nonResourceRules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching nonResourceRules. No match found.");
        return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
    }

    public A addToResourceRules(int index,ResourceRule item) {
        if (this.resourceRules == null) {this.resourceRules = new ArrayList<ResourceRuleBuilder>();}
        ResourceRuleBuilder builder = new ResourceRuleBuilder(item);_visitables.get("resourceRules").add(index >= 0 ? index : _visitables.get("resourceRules").size(), builder);this.resourceRules.add(index >= 0 ? index : resourceRules.size(), builder); return (A)this;
    }

    public A setToResourceRules(int index,ResourceRule item) {
        if (this.resourceRules == null) {this.resourceRules = new ArrayList<ResourceRuleBuilder>();}
        ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
        if (index < 0 || index >= _visitables.get("resourceRules").size()) { _visitables.get("resourceRules").add(builder); } else { _visitables.get("resourceRules").set(index, builder);}
        if (index < 0 || index >= resourceRules.size()) { resourceRules.add(builder); } else { resourceRules.set(index, builder);}
         return (A)this;
    }

    public A addToResourceRules(ResourceRule... items) {
        if (this.resourceRules == null) {this.resourceRules = new ArrayList<ResourceRuleBuilder>();}
        for (ResourceRule item : items) {ResourceRuleBuilder builder = new ResourceRuleBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
    }

    public A addAllToResourceRules(Collection<ResourceRule> items) {
        if (this.resourceRules == null) {this.resourceRules = new ArrayList<ResourceRuleBuilder>();}
        for (ResourceRule item : items) {ResourceRuleBuilder builder = new ResourceRuleBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
    }

    public A removeFromResourceRules(ResourceRule... items) {
        for (ResourceRule item : items) {ResourceRuleBuilder builder = new ResourceRuleBuilder(item);_visitables.get("resourceRules").remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
    }

    public A removeAllFromResourceRules(Collection<ResourceRule> items) {
        for (ResourceRule item : items) {ResourceRuleBuilder builder = new ResourceRuleBuilder(item);_visitables.get("resourceRules").remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResourceRules(Predicate<ResourceRuleBuilder> predicate) {
        if (resourceRules == null) return (A) this;
        final Iterator<ResourceRuleBuilder> each = resourceRules.iterator();
        final List visitables = _visitables.get("resourceRules");
        while (each.hasNext()) {
          ResourceRuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResourceRules instead.
 * @return The buildable object.
 */
@Deprecated public List<ResourceRule> getResourceRules() {
        return build(resourceRules);
    }

    public List<ResourceRule> buildResourceRules() {
        return build(resourceRules);
    }

    public ResourceRule buildResourceRule(int index) {
        return this.resourceRules.get(index).build();
    }

    public ResourceRule buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    public ResourceRule buildLastResourceRule() {
        return this.resourceRules.get(resourceRules.size() - 1).build();
    }

    public ResourceRule buildMatchingResourceRule(Predicate<ResourceRuleBuilder> predicate) {
        for (ResourceRuleBuilder item: resourceRules) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingResourceRule(Predicate<ResourceRuleBuilder> predicate) {
        for (ResourceRuleBuilder item: resourceRules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withResourceRules(List<ResourceRule> resourceRules) {
        if (this.resourceRules != null) { _visitables.get("resourceRules").removeAll(this.resourceRules);}
        if (resourceRules != null) {this.resourceRules = new ArrayList<ResourceRuleBuilder>(); for (ResourceRule item : resourceRules){this.addToResourceRules(item);}} else { this.resourceRules = null;} return (A) this;
    }

    public A withResourceRules(ResourceRule... resourceRules) {
        if (this.resourceRules != null) {this.resourceRules.clear();}
        if (resourceRules != null) {for (ResourceRule item :resourceRules){ this.addToResourceRules(item);}} return (A) this;
    }

    public Boolean hasResourceRules() {
        return resourceRules != null && !resourceRules.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRuleLike(ResourceRule item) {
        return new ResourceRulesNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> setNewResourceRuleLike(int index,ResourceRule item) {
        return new ResourceRulesNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editResourceRule(int index) {
        if (resourceRules.size() <= index) throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
        return setNewResourceRuleLike(index, buildResourceRule(index));
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editFirstResourceRule() {
        if (resourceRules.size() == 0) throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
        return setNewResourceRuleLike(0, buildResourceRule(0));
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editLastResourceRule() {
        int index = resourceRules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
        return setNewResourceRuleLike(index, buildResourceRule(index));
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editMatchingResourceRule(Predicate<ResourceRuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<resourceRules.size();i++) { 
        if (predicate.test(resourceRules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching resourceRules. No match found.");
        return setNewResourceRuleLike(index, buildResourceRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubjectRulesReviewStatusFluentImpl that = (SubjectRulesReviewStatusFluentImpl) o;
        if (evaluationError != null ? !evaluationError.equals(that.evaluationError) :that.evaluationError != null) return false;
        if (incomplete != null ? !incomplete.equals(that.incomplete) :that.incomplete != null) return false;
        if (nonResourceRules != null ? !nonResourceRules.equals(that.nonResourceRules) :that.nonResourceRules != null) return false;
        if (resourceRules != null ? !resourceRules.equals(that.resourceRules) :that.resourceRules != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(evaluationError,  incomplete,  nonResourceRules,  resourceRules,  super.hashCode());
    }

    public class NonResourceRulesNestedImpl<N> extends NonResourceRuleFluentImpl<io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>> implements io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NonResourceRuleBuilder builder;
        private final int index;

            NonResourceRulesNestedImpl(int index,NonResourceRule item) {
                this.index = index;
                this.builder = new NonResourceRuleBuilder(this, item);
                        
            }

            NonResourceRulesNestedImpl() {
                this.index = -1;
                this.builder = new NonResourceRuleBuilder(this);
                        
            }

            public N and() {
                return (N) SubjectRulesReviewStatusFluentImpl.this.setToNonResourceRules(index,builder.build());
            }

            public N endNonResourceRule() {
                return and();
            }
    }


    public class ResourceRulesNestedImpl<N> extends ResourceRuleFluentImpl<io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<N>> implements io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceRuleBuilder builder;
        private final int index;

            ResourceRulesNestedImpl(int index,ResourceRule item) {
                this.index = index;
                this.builder = new ResourceRuleBuilder(this, item);
                        
            }

            ResourceRulesNestedImpl() {
                this.index = -1;
                this.builder = new ResourceRuleBuilder(this);
                        
            }

            public N and() {
                return (N) SubjectRulesReviewStatusFluentImpl.this.setToResourceRules(index,builder.build());
            }

            public N endResourceRule() {
                return and();
            }
    }


}
