package io.fabric8.kubernetes.api.model.apiextensions.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface CustomResourceConversionFluent<A extends CustomResourceConversionFluent<A>> extends Fluent<A> {


    public String getStrategy();
    public A withStrategy(String strategy);
    public Boolean hasStrategy();
    public A withNewStrategy(String arg1);
    public A withNewStrategy(StringBuilder arg1);
    public A withNewStrategy(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildWebhook instead.
 * @return The buildable object.
 */
@Deprecated public WebhookConversion getWebhook();
    public WebhookConversion buildWebhook();
    public A withWebhook(WebhookConversion webhook);
    public Boolean hasWebhook();
    public CustomResourceConversionFluent.WebhookNested<A> withNewWebhook();
    public CustomResourceConversionFluent.WebhookNested<A> withNewWebhookLike(WebhookConversion item);
    public CustomResourceConversionFluent.WebhookNested<A> editWebhook();
    public CustomResourceConversionFluent.WebhookNested<A> editOrNewWebhook();
    public CustomResourceConversionFluent.WebhookNested<A> editOrNewWebhookLike(WebhookConversion item);
    public interface WebhookNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,WebhookConversionFluent<CustomResourceConversionFluent.WebhookNested<N>> {

            public N and();
            public N endWebhook();    }


}
