package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class CustomResourceDefinitionStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent<A> {

    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder acceptedNames;
    private List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder> conditions =  new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder>();
    private List<String> storedVersions = new ArrayList<String>();

    public CustomResourceDefinitionStatusFluentImpl() {
    }

    public CustomResourceDefinitionStatusFluentImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus instance) {
        this.withAcceptedNames(instance.getAcceptedNames()); 
        this.withConditions(instance.getConditions()); 
        this.withStoredVersions(instance.getStoredVersions()); 
    }

    
/**
 * This method has been deprecated, please use method buildAcceptedNames instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames getAcceptedNames() {
        return this.acceptedNames!=null?this.acceptedNames.build():null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames buildAcceptedNames() {
        return this.acceptedNames!=null?this.acceptedNames.build():null;
    }

    public A withAcceptedNames(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames acceptedNames) {
        _visitables.get("acceptedNames").remove(this.acceptedNames);
        if (acceptedNames!=null){ this.acceptedNames= new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(acceptedNames); _visitables.get("acceptedNames").add(this.acceptedNames);} return (A) this;
    }

    public Boolean hasAcceptedNames() {
        return this.acceptedNames != null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> withNewAcceptedNames() {
        return new AcceptedNamesNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> withNewAcceptedNamesLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
        return new AcceptedNamesNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> editAcceptedNames() {
        return withNewAcceptedNamesLike(getAcceptedNames());
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> editOrNewAcceptedNames() {
        return withNewAcceptedNamesLike(getAcceptedNames() != null ? getAcceptedNames(): new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.AcceptedNamesNested<A> editOrNewAcceptedNamesLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
        return withNewAcceptedNamesLike(getAcceptedNames() != null ? getAcceptedNames(): item);
    }

    public A addToConditions(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition... items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition> items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition> getConditions() {
        return build(conditions);
    }

    public List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition buildMatchingCondition(Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder>(); for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)addToConditions(new CustomResourceDefinitionCondition(lastTransitionTime, message, reason, status, type));
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public A addToStoredVersions(int index,String item) {
        if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
        this.storedVersions.add(index, item);
        return (A)this;
    }

    public A setToStoredVersions(int index,String item) {
        if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
        this.storedVersions.set(index, item); return (A)this;
    }

    public A addToStoredVersions(String... items) {
        if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
        for (String item : items) {this.storedVersions.add(item);} return (A)this;
    }

    public A addAllToStoredVersions(Collection<String> items) {
        if (this.storedVersions == null) {this.storedVersions = new ArrayList<String>();}
        for (String item : items) {this.storedVersions.add(item);} return (A)this;
    }

    public A removeFromStoredVersions(String... items) {
        for (String item : items) {if (this.storedVersions!= null){ this.storedVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromStoredVersions(Collection<String> items) {
        for (String item : items) {if (this.storedVersions!= null){ this.storedVersions.remove(item);}} return (A)this;
    }

    public List<String> getStoredVersions() {
        return this.storedVersions;
    }

    public String getStoredVersion(int index) {
        return this.storedVersions.get(index);
    }

    public String getFirstStoredVersion() {
        return this.storedVersions.get(0);
    }

    public String getLastStoredVersion() {
        return this.storedVersions.get(storedVersions.size() - 1);
    }

    public String getMatchingStoredVersion(Predicate<String> predicate) {
        for (String item: storedVersions) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingStoredVersion(Predicate<String> predicate) {
        for (String item: storedVersions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withStoredVersions(List<String> storedVersions) {
        if (this.storedVersions != null) { _visitables.get("storedVersions").removeAll(this.storedVersions);}
        if (storedVersions != null) {this.storedVersions = new ArrayList<String>(); for (String item : storedVersions){this.addToStoredVersions(item);}} else { this.storedVersions = null;} return (A) this;
    }

    public A withStoredVersions(String... storedVersions) {
        if (this.storedVersions != null) {this.storedVersions.clear();}
        if (storedVersions != null) {for (String item :storedVersions){ this.addToStoredVersions(item);}} return (A) this;
    }

    public Boolean hasStoredVersions() {
        return storedVersions != null && !storedVersions.isEmpty();
    }

    public A addNewStoredVersion(StringBuilder arg1) {
        return (A)addToStoredVersions(new String(arg1));
    }

    public A addNewStoredVersion(int[] arg1,int arg2,int arg3) {
        return (A)addToStoredVersions(new String(arg1, arg2, arg3));
    }

    public A addNewStoredVersion(char[] arg1) {
        return (A)addToStoredVersions(new String(arg1));
    }

    public A addNewStoredVersion(StringBuffer arg1) {
        return (A)addToStoredVersions(new String(arg1));
    }

    public A addNewStoredVersion(byte[] arg1,int arg2) {
        return (A)addToStoredVersions(new String(arg1, arg2));
    }

    public A addNewStoredVersion(byte[] arg1) {
        return (A)addToStoredVersions(new String(arg1));
    }

    public A addNewStoredVersion(char[] arg1,int arg2,int arg3) {
        return (A)addToStoredVersions(new String(arg1, arg2, arg3));
    }

    public A addNewStoredVersion(byte[] arg1,int arg2,int arg3) {
        return (A)addToStoredVersions(new String(arg1, arg2, arg3));
    }

    public A addNewStoredVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToStoredVersions(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewStoredVersion(String arg1) {
        return (A)addToStoredVersions(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomResourceDefinitionStatusFluentImpl that = (CustomResourceDefinitionStatusFluentImpl) o;
        if (acceptedNames != null ? !acceptedNames.equals(that.acceptedNames) :that.acceptedNames != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (storedVersions != null ? !storedVersions.equals(that.storedVersions) :that.storedVersions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(acceptedNames,  conditions,  storedVersions,  super.hashCode());
    }

    public class AcceptedNamesNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.AcceptedNamesNested<N>> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.AcceptedNamesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder builder;

            AcceptedNamesNestedImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(this, item);
                        
            }

            AcceptedNamesNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(this);
                        
            }

            public N and() {
                return (N) CustomResourceDefinitionStatusFluentImpl.this.withAcceptedNames(builder.build());
            }

            public N endAcceptedNames() {
                return and();
            }
    }


    public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionFluentImpl<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(this);
                        
            }

            public N and() {
                return (N) CustomResourceDefinitionStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


}
