package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CustomResourceDefinitionSpecBuilder extends CustomResourceDefinitionSpecFluentImpl<CustomResourceDefinitionSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CustomResourceDefinitionSpec,CustomResourceDefinitionSpecBuilder> {

    CustomResourceDefinitionSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CustomResourceDefinitionSpecBuilder() {
        this(true);
    }

    public CustomResourceDefinitionSpecBuilder(Boolean validationEnabled) {
        this(new CustomResourceDefinitionSpec(), validationEnabled);
    }

    public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CustomResourceDefinitionSpec(), validationEnabled);
    }

    public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent,CustomResourceDefinitionSpec instance) {
        this(fluent, instance, true);
    }

    public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent,CustomResourceDefinitionSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConversion(instance.getConversion()); 
        fluent.withGroup(instance.getGroup()); 
        fluent.withNames(instance.getNames()); 
        fluent.withPreserveUnknownFields(instance.getPreserveUnknownFields()); 
        fluent.withScope(instance.getScope()); 
        fluent.withVersions(instance.getVersions()); 
        this.validationEnabled = validationEnabled; 
    }

    public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpec instance) {
        this(instance,true);
    }

    public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConversion(instance.getConversion()); 
        this.withGroup(instance.getGroup()); 
        this.withNames(instance.getNames()); 
        this.withPreserveUnknownFields(instance.getPreserveUnknownFields()); 
        this.withScope(instance.getScope()); 
        this.withVersions(instance.getVersions()); 
        this.validationEnabled = validationEnabled; 
    }

    public CustomResourceDefinitionSpec build() {
        CustomResourceDefinitionSpec buildable = new CustomResourceDefinitionSpec(fluent.getConversion(),fluent.getGroup(),fluent.getNames(),fluent.getPreserveUnknownFields(),fluent.getScope(),fluent.getVersions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomResourceDefinitionSpecBuilder that = (CustomResourceDefinitionSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
