package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DaemonSetSpecBuilder extends DaemonSetSpecFluent<DaemonSetSpecBuilder> implements VisitableBuilder<DaemonSetSpec,DaemonSetSpecBuilder>{
  public DaemonSetSpecBuilder() {
    this(new DaemonSetSpec());
  }
  
  public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent) {
    this(fluent, new DaemonSetSpec());
  }
  
  public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent,DaemonSetSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DaemonSetSpecBuilder(DaemonSetSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DaemonSetSpecFluent<?> fluent;
  
  public DaemonSetSpec build() {
    DaemonSetSpec buildable = new DaemonSetSpec(fluent.getMinReadySeconds(),fluent.getRevisionHistoryLimit(),fluent.buildSelector(),fluent.buildTemplate(),fluent.buildUpdateStrategy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}