package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ReplicaSetSpecBuilder extends ReplicaSetSpecFluent<ReplicaSetSpecBuilder> implements VisitableBuilder<ReplicaSetSpec,ReplicaSetSpecBuilder>{
  public ReplicaSetSpecBuilder() {
    this(new ReplicaSetSpec());
  }
  
  public ReplicaSetSpecBuilder(ReplicaSetSpecFluent<?> fluent) {
    this(fluent, new ReplicaSetSpec());
  }
  
  public ReplicaSetSpecBuilder(ReplicaSetSpecFluent<?> fluent,ReplicaSetSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ReplicaSetSpecBuilder(ReplicaSetSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ReplicaSetSpecFluent<?> fluent;
  
  public ReplicaSetSpec build() {
    ReplicaSetSpec buildable = new ReplicaSetSpec(fluent.getMinReadySeconds(),fluent.getReplicas(),fluent.buildSelector(),fluent.buildTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}