/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluentImpl;

public class StatefulSetBuilder
extends StatefulSetFluentImpl<StatefulSetBuilder>
implements VisitableBuilder<StatefulSet, StatefulSetBuilder> {
    StatefulSetFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetBuilder() {
        this(false);
    }

    public StatefulSetBuilder(Boolean validationEnabled) {
        this(new StatefulSet(), validationEnabled);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSet(), validationEnabled);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent, StatefulSet instance) {
        this(fluent, instance, false);
    }

    public StatefulSetBuilder(StatefulSetFluent<?> fluent, StatefulSet instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetBuilder(StatefulSet instance) {
        this(instance, (Boolean)false);
    }

    public StatefulSetBuilder(StatefulSet instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSet build() {
        StatefulSet buildable = new StatefulSet(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

