package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class ObjectMetricStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<A> {

    private MetricValueStatusBuilder current;
    private io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder describedObject;
    private MetricIdentifierBuilder metric;

    public ObjectMetricStatusFluentImpl() { 
    }


    public ObjectMetricStatusFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus instance) { 
        this.withCurrent(instance.getCurrent()); 
        this.withDescribedObject(instance.getDescribedObject()); 
        this.withMetric(instance.getMetric()); 
    }


    
/**
 * This method has been deprecated, please use method buildCurrent instead.
 * @return The buildable object.
 */
@Deprecated public MetricValueStatus getCurrent() {
        return this.current!=null?this.current.build():null;
    }

    public MetricValueStatus buildCurrent() {
        return this.current!=null?this.current.build():null;
    }

    public A withCurrent(MetricValueStatus current) {
        _visitables.get("current").remove(this.current);
        if (current!=null){ this.current= new MetricValueStatusBuilder(current); _visitables.get("current").add(this.current);} return (A) this;
    }

    public Boolean hasCurrent() {
        return this.current != null;
    }

    public ObjectMetricStatusFluent.CurrentNested<A> withNewCurrent() {
        return new CurrentNestedImpl();
    }

    public ObjectMetricStatusFluent.CurrentNested<A> withNewCurrentLike(MetricValueStatus item) {
        return new CurrentNestedImpl(item);
    }

    public ObjectMetricStatusFluent.CurrentNested<A> editCurrent() {
        return withNewCurrentLike(getCurrent());
    }

    public ObjectMetricStatusFluent.CurrentNested<A> editOrNewCurrent() {
        return withNewCurrentLike(getCurrent() != null ? getCurrent(): new MetricValueStatusBuilder().build());
    }

    public ObjectMetricStatusFluent.CurrentNested<A> editOrNewCurrentLike(MetricValueStatus item) {
        return withNewCurrentLike(getCurrent() != null ? getCurrent(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDescribedObject instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference getDescribedObject() {
        return this.describedObject!=null?this.describedObject.build():null;
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference buildDescribedObject() {
        return this.describedObject!=null?this.describedObject.build():null;
    }

    public A withDescribedObject(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference describedObject) {
        _visitables.get("describedObject").remove(this.describedObject);
        if (describedObject!=null){ this.describedObject= new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder(describedObject); _visitables.get("describedObject").add(this.describedObject);} return (A) this;
    }

    public Boolean hasDescribedObject() {
        return this.describedObject != null;
    }

    public A withNewDescribedObject(String apiVersion,String kind,String name) {
        return (A)withDescribedObject(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public ObjectMetricStatusFluent.DescribedObjectNested<A> withNewDescribedObject() {
        return new DescribedObjectNestedImpl();
    }

    public ObjectMetricStatusFluent.DescribedObjectNested<A> withNewDescribedObjectLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference item) {
        return new DescribedObjectNestedImpl(item);
    }

    public ObjectMetricStatusFluent.DescribedObjectNested<A> editDescribedObject() {
        return withNewDescribedObjectLike(getDescribedObject());
    }

    public ObjectMetricStatusFluent.DescribedObjectNested<A> editOrNewDescribedObject() {
        return withNewDescribedObjectLike(getDescribedObject() != null ? getDescribedObject(): new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder().build());
    }

    public ObjectMetricStatusFluent.DescribedObjectNested<A> editOrNewDescribedObjectLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference item) {
        return withNewDescribedObjectLike(getDescribedObject() != null ? getDescribedObject(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMetric instead.
 * @return The buildable object.
 */
@Deprecated public MetricIdentifier getMetric() {
        return this.metric!=null?this.metric.build():null;
    }

    public MetricIdentifier buildMetric() {
        return this.metric!=null?this.metric.build():null;
    }

    public A withMetric(MetricIdentifier metric) {
        _visitables.get("metric").remove(this.metric);
        if (metric!=null){ this.metric= new MetricIdentifierBuilder(metric); _visitables.get("metric").add(this.metric);} return (A) this;
    }

    public Boolean hasMetric() {
        return this.metric != null;
    }

    public ObjectMetricStatusFluent.MetricNested<A> withNewMetric() {
        return new MetricNestedImpl();
    }

    public ObjectMetricStatusFluent.MetricNested<A> withNewMetricLike(MetricIdentifier item) {
        return new MetricNestedImpl(item);
    }

    public ObjectMetricStatusFluent.MetricNested<A> editMetric() {
        return withNewMetricLike(getMetric());
    }

    public ObjectMetricStatusFluent.MetricNested<A> editOrNewMetric() {
        return withNewMetricLike(getMetric() != null ? getMetric(): new MetricIdentifierBuilder().build());
    }

    public ObjectMetricStatusFluent.MetricNested<A> editOrNewMetricLike(MetricIdentifier item) {
        return withNewMetricLike(getMetric() != null ? getMetric(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ObjectMetricStatusFluentImpl that = (ObjectMetricStatusFluentImpl) o;
        if (current != null ? !current.equals(that.current) :that.current != null) return false;
        if (describedObject != null ? !describedObject.equals(that.describedObject) :that.describedObject != null) return false;
        if (metric != null ? !metric.equals(that.metric) :that.metric != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(current,  describedObject,  metric,  super.hashCode());
    }

    public class CurrentNestedImpl<N> extends MetricValueStatusFluentImpl<ObjectMetricStatusFluent.CurrentNested<N>> implements ObjectMetricStatusFluent.CurrentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MetricValueStatusBuilder builder;

        CurrentNestedImpl(MetricValueStatus item) {
            this.builder = new MetricValueStatusBuilder(this, item);
        }

        CurrentNestedImpl() {
            this.builder = new MetricValueStatusBuilder(this);
        }

        public N and() {
             return (N) ObjectMetricStatusFluentImpl.this.withCurrent(builder.build());
        }

        public N endCurrent() {
             return and();
        }
    }


    public class DescribedObjectNestedImpl<N> extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceFluentImpl<ObjectMetricStatusFluent.DescribedObjectNested<N>> implements ObjectMetricStatusFluent.DescribedObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder builder;

        DescribedObjectNestedImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference item) {
            this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder(this, item);
        }

        DescribedObjectNestedImpl() {
            this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) ObjectMetricStatusFluentImpl.this.withDescribedObject(builder.build());
        }

        public N endDescribedObject() {
             return and();
        }
    }


    public class MetricNestedImpl<N> extends MetricIdentifierFluentImpl<ObjectMetricStatusFluent.MetricNested<N>> implements ObjectMetricStatusFluent.MetricNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MetricIdentifierBuilder builder;

        MetricNestedImpl(MetricIdentifier item) {
            this.builder = new MetricIdentifierBuilder(this, item);
        }

        MetricNestedImpl() {
            this.builder = new MetricIdentifierBuilder(this);
        }

        public N and() {
             return (N) ObjectMetricStatusFluentImpl.this.withMetric(builder.build());
        }

        public N endMetric() {
             return and();
        }
    }


}
