package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceMetricSourceBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceMetricSourceBuilder() { 
        this(true);
    }


    public ResourceMetricSourceBuilder(Boolean validationEnabled) { 
        this(new ResourceMetricSource(), validationEnabled);
    }


    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ResourceMetricSource(), validationEnabled);
    }


    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource instance) { 
        this(fluent, instance, true);
    }


    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withTarget(instance.getTarget()); 
        this.validationEnabled = validationEnabled; 
    }


    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource instance) { 
        this(instance,true);
    }


    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withTarget(instance.getTarget()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource build() {
        ResourceMetricSource buildable = new ResourceMetricSource(fluent.getName(),fluent.getTarget());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceMetricSourceBuilder that = (ResourceMetricSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
