/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluentImpl;
import java.util.Objects;

public class ResourceMetricSourceBuilder
extends ResourceMetricSourceFluentImpl<ResourceMetricSourceBuilder>
implements VisitableBuilder<ResourceMetricSource, ResourceMetricSourceBuilder> {
    ResourceMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceMetricSourceBuilder() {
        this(true);
    }

    public ResourceMetricSourceBuilder(Boolean validationEnabled) {
        this(new ResourceMetricSource(), validationEnabled);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceMetricSource(), validationEnabled);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, ResourceMetricSource instance) {
        this(fluent, instance, true);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, ResourceMetricSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withTarget(instance.getTarget());
        this.validationEnabled = validationEnabled;
    }

    public ResourceMetricSourceBuilder(ResourceMetricSource instance) {
        this(instance, (Boolean)true);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withTarget(instance.getTarget());
        this.validationEnabled = validationEnabled;
    }

    public ResourceMetricSource build() {
        ResourceMetricSource buildable = new ResourceMetricSource(this.fluent.getName(), this.fluent.getTarget());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMetricSourceBuilder that = (ResourceMetricSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

