package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ResourceMetricStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatusBuilder>{
  public ResourceMetricStatusBuilder() {
    this(false);
  }
  public ResourceMetricStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new ResourceMetricStatus(), validationEnabled);
  }
  public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ResourceMetricStatus(), validationEnabled);
  }
  public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatus instance) {
    this(fluent, instance, false);
  }
  public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCurrentAverageUtilization(instance.getCurrentAverageUtilization()); 
    fluent.withCurrentAverageValue(instance.getCurrentAverageValue()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatus instance) {
    this(instance,false);
  }
  public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization()); 
    this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatus build() {
    ResourceMetricStatus buildable = new ResourceMetricStatus(fluent.getCurrentAverageUtilization(),fluent.getCurrentAverageValue(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceMetricStatusBuilder that = (ResourceMetricStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}