/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRule;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpec;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLS;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLSBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressTLSFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>>
extends BaseFluent<A>
implements IngressSpecFluent<A> {
    private IngressBackendBuilder defaultBackend;
    private String ingressClassName;
    private List<IngressRuleBuilder> rules = new ArrayList<IngressRuleBuilder>();
    private List<IngressTLSBuilder> tls = new ArrayList<IngressTLSBuilder>();
    private Map<String, Object> additionalProperties;

    public IngressSpecFluentImpl() {
    }

    public IngressSpecFluentImpl(IngressSpec instance) {
        this.withDefaultBackend(instance.getDefaultBackend());
        this.withIngressClassName(instance.getIngressClassName());
        this.withRules(instance.getRules());
        this.withTls(instance.getTls());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public IngressBackend getDefaultBackend() {
        return this.defaultBackend != null ? this.defaultBackend.build() : null;
    }

    @Override
    public IngressBackend buildDefaultBackend() {
        return this.defaultBackend != null ? this.defaultBackend.build() : null;
    }

    @Override
    public A withDefaultBackend(IngressBackend defaultBackend) {
        this._visitables.get((Object)"defaultBackend").remove(this.defaultBackend);
        if (defaultBackend != null) {
            this.defaultBackend = new IngressBackendBuilder(defaultBackend);
            this._visitables.get((Object)"defaultBackend").add(this.defaultBackend);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultBackend() {
        return this.defaultBackend != null;
    }

    @Override
    public IngressSpecFluent.DefaultBackendNested<A> withNewDefaultBackend() {
        return new DefaultBackendNestedImpl();
    }

    @Override
    public IngressSpecFluent.DefaultBackendNested<A> withNewDefaultBackendLike(IngressBackend item) {
        return new DefaultBackendNestedImpl(item);
    }

    @Override
    public IngressSpecFluent.DefaultBackendNested<A> editDefaultBackend() {
        return this.withNewDefaultBackendLike(this.getDefaultBackend());
    }

    @Override
    public IngressSpecFluent.DefaultBackendNested<A> editOrNewDefaultBackend() {
        return this.withNewDefaultBackendLike(this.getDefaultBackend() != null ? this.getDefaultBackend() : new IngressBackendBuilder().build());
    }

    @Override
    public IngressSpecFluent.DefaultBackendNested<A> editOrNewDefaultBackendLike(IngressBackend item) {
        return this.withNewDefaultBackendLike(this.getDefaultBackend() != null ? this.getDefaultBackend() : item);
    }

    @Override
    public String getIngressClassName() {
        return this.ingressClassName;
    }

    @Override
    public A withIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return (A)this;
    }

    @Override
    public Boolean hasIngressClassName() {
        return this.ingressClassName != null;
    }

    @Override
    @Deprecated
    public A withNewIngressClassName(String arg0) {
        return this.withIngressClassName(new String(arg0));
    }

    @Override
    public A addToRules(Integer index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        this._visitables.get((Object)"rules").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"rules").size(), builder);
        this.rules.add(index >= 0 ? index.intValue() : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(Integer index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"rules").size()) {
            this._visitables.get((Object)"rules").add(builder);
        } else {
            this._visitables.get((Object)"rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(IngressRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<IngressRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(IngressRule ... items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<IngressRule> items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<IngressRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<IngressRuleBuilder> each = this.rules.iterator();
        List visitables = this._visitables.get((Object)"rules");
        while (each.hasNext()) {
            IngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IngressRule> getRules() {
        return IngressSpecFluentImpl.build(this.rules);
    }

    @Override
    public List<IngressRule> buildRules() {
        return IngressSpecFluentImpl.build(this.rules);
    }

    @Override
    public IngressRule buildRule(Integer index) {
        return this.rules.get(index).build();
    }

    @Override
    public IngressRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public IngressRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public IngressRule buildMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<IngressRule> rules) {
        if (this.rules != null) {
            this._visitables.get((Object)"rules").removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(IngressRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public IngressSpecFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public IngressSpecFluent.RulesNested<A> addNewRuleLike(IngressRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public IngressSpecFluent.RulesNested<A> setNewRuleLike(Integer index, IngressRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editRule(Integer index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public A addToTls(Integer index, IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        IngressTLSBuilder builder = new IngressTLSBuilder(item);
        this._visitables.get((Object)"tls").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"tls").size(), builder);
        this.tls.add(index >= 0 ? index.intValue() : this.tls.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTls(Integer index, IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        IngressTLSBuilder builder = new IngressTLSBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"tls").size()) {
            this._visitables.get((Object)"tls").add(builder);
        } else {
            this._visitables.get((Object)"tls").set(index, builder);
        }
        if (index < 0 || index >= this.tls.size()) {
            this.tls.add(builder);
        } else {
            this.tls.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTls(IngressTLS ... items) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTls(Collection<IngressTLS> items) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTls(IngressTLS ... items) {
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").remove(builder);
            if (this.tls == null) continue;
            this.tls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTls(Collection<IngressTLS> items) {
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").remove(builder);
            if (this.tls == null) continue;
            this.tls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTls(Predicate<IngressTLSBuilder> predicate) {
        if (this.tls == null) {
            return (A)this;
        }
        Iterator<IngressTLSBuilder> each = this.tls.iterator();
        List visitables = this._visitables.get((Object)"tls");
        while (each.hasNext()) {
            IngressTLSBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IngressTLS> getTls() {
        return IngressSpecFluentImpl.build(this.tls);
    }

    @Override
    public List<IngressTLS> buildTls() {
        return IngressSpecFluentImpl.build(this.tls);
    }

    @Override
    public IngressTLS buildTl(Integer index) {
        return this.tls.get(index).build();
    }

    @Override
    public IngressTLS buildFirstTl() {
        return this.tls.get(0).build();
    }

    @Override
    public IngressTLS buildLastTl() {
        return this.tls.get(this.tls.size() - 1).build();
    }

    @Override
    public IngressTLS buildMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        for (IngressTLSBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        for (IngressTLSBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTls(List<IngressTLS> tls) {
        if (this.tls != null) {
            this._visitables.get((Object)"tls").removeAll(this.tls);
        }
        if (tls != null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
            for (IngressTLS item : tls) {
                this.addToTls(item);
            }
        } else {
            this.tls = null;
        }
        return (A)this;
    }

    @Override
    public A withTls(IngressTLS ... tls) {
        if (this.tls != null) {
            this.tls.clear();
        }
        if (tls != null) {
            for (IngressTLS item : tls) {
                this.addToTls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null && !this.tls.isEmpty();
    }

    @Override
    public IngressSpecFluent.TlsNested<A> addNewTl() {
        return new TlsNestedImpl();
    }

    @Override
    public IngressSpecFluent.TlsNested<A> addNewTlLike(IngressTLS item) {
        return new TlsNestedImpl(-1, item);
    }

    @Override
    public IngressSpecFluent.TlsNested<A> setNewTlLike(Integer index, IngressTLS item) {
        return new TlsNestedImpl(index, item);
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editTl(Integer index) {
        if (this.tls.size() <= index) {
            throw new RuntimeException("Can't edit tls. Index exceeds size.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editFirstTl() {
        if (this.tls.size() == 0) {
            throw new RuntimeException("Can't edit first tls. The list is empty.");
        }
        return this.setNewTlLike(0, this.buildTl(0));
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editLastTl() {
        int index = this.tls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tls. The list is empty.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tls.size(); ++i) {
            if (!predicate.test(this.tls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tls. No match found.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressSpecFluentImpl that = (IngressSpecFluentImpl)o;
        if (this.defaultBackend != null ? !this.defaultBackend.equals(that.defaultBackend) : that.defaultBackend != null) {
            return false;
        }
        if (this.ingressClassName != null ? !this.ingressClassName.equals(that.ingressClassName) : that.ingressClassName != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.defaultBackend, this.ingressClassName, this.rules, this.tls, this.additionalProperties, super.hashCode());
    }

    public class TlsNestedImpl<N>
    extends IngressTLSFluentImpl<IngressSpecFluent.TlsNested<N>>
    implements IngressSpecFluent.TlsNested<N>,
    Nested<N> {
        IngressTLSBuilder builder;
        Integer index;

        TlsNestedImpl(Integer index, IngressTLS item) {
            this.index = index;
            this.builder = new IngressTLSBuilder(this, item);
        }

        TlsNestedImpl() {
            this.index = -1;
            this.builder = new IngressTLSBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.setToTls(this.index, this.builder.build());
        }

        @Override
        public N endTl() {
            return this.and();
        }
    }

    public class RulesNestedImpl<N>
    extends IngressRuleFluentImpl<IngressSpecFluent.RulesNested<N>>
    implements IngressSpecFluent.RulesNested<N>,
    Nested<N> {
        IngressRuleBuilder builder;
        Integer index;

        RulesNestedImpl(Integer index, IngressRule item) {
            this.index = index;
            this.builder = new IngressRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new IngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class DefaultBackendNestedImpl<N>
    extends IngressBackendFluentImpl<IngressSpecFluent.DefaultBackendNested<N>>
    implements IngressSpecFluent.DefaultBackendNested<N>,
    Nested<N> {
        IngressBackendBuilder builder;

        DefaultBackendNestedImpl(IngressBackend item) {
            this.builder = new IngressBackendBuilder(this, item);
        }

        DefaultBackendNestedImpl() {
            this.builder = new IngressBackendBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.withDefaultBackend(this.builder.build());
        }

        @Override
        public N endDefaultBackend() {
            return this.and();
        }
    }
}

