package io.fabric8.kubernetes.api.model.networking.v1beta1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class IngressClassSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassSpecFluent<A> {

    private String controller;
    private TypedLocalObjectReference parameters;

    public IngressClassSpecFluentImpl() {
    }

    public IngressClassSpecFluentImpl(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassSpec instance) {
        this.withController(instance.getController()); 
        this.withParameters(instance.getParameters()); 
    }

    public String getController() {
        return this.controller;
    }

    public A withController(String controller) {
        this.controller=controller; return (A) this;
    }

    public Boolean hasController() {
        return this.controller != null;
    }

    public A withNewController(StringBuilder arg1) {
        return (A)withController(new String(arg1));
    }

    public A withNewController(int[] arg1,int arg2,int arg3) {
        return (A)withController(new String(arg1, arg2, arg3));
    }

    public A withNewController(char[] arg1) {
        return (A)withController(new String(arg1));
    }

    public A withNewController(StringBuffer arg1) {
        return (A)withController(new String(arg1));
    }

    public A withNewController(byte[] arg1,int arg2) {
        return (A)withController(new String(arg1, arg2));
    }

    public A withNewController(byte[] arg1) {
        return (A)withController(new String(arg1));
    }

    public A withNewController(char[] arg1,int arg2,int arg3) {
        return (A)withController(new String(arg1, arg2, arg3));
    }

    public A withNewController(byte[] arg1,int arg2,int arg3) {
        return (A)withController(new String(arg1, arg2, arg3));
    }

    public A withNewController(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withController(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewController(String arg1) {
        return (A)withController(new String(arg1));
    }

    public TypedLocalObjectReference getParameters() {
        return this.parameters;
    }

    public A withParameters(TypedLocalObjectReference parameters) {
        this.parameters=parameters; return (A) this;
    }

    public Boolean hasParameters() {
        return this.parameters != null;
    }

    public A withNewParameters(String apiGroup,String kind,String name) {
        return (A)withParameters(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressClassSpecFluentImpl that = (IngressClassSpecFluentImpl) o;
        if (controller != null ? !controller.equals(that.controller) :that.controller != null) return false;
        if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(controller,  parameters,  super.hashCode());
    }

}
