package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface IngressListFluent<A extends IngressListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,Ingress item);
    public A setToItems(int index,Ingress item);
    public A addToItems(Ingress... items);
    public A addAllToItems(Collection<Ingress> items);
    public A removeFromItems(Ingress... items);
    public A removeAllFromItems(Collection<Ingress> items);
    public A removeMatchingFromItems(Predicate<IngressBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Ingress> getItems();
    public List<Ingress> buildItems();
    public Ingress buildItem(int index);
    public Ingress buildFirstItem();
    public Ingress buildLastItem();
    public Ingress buildMatchingItem(Predicate<IngressBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<IngressBuilder> predicate);
    public A withItems(List<Ingress> items);
    public A withItems(Ingress... items);
    public Boolean hasItems();
    public IngressListFluent.ItemsNested<A> addNewItem();
    public IngressListFluent.ItemsNested<A> addNewItemLike(Ingress item);
    public IngressListFluent.ItemsNested<A> setNewItemLike(int index,Ingress item);
    public IngressListFluent.ItemsNested<A> editItem(int index);
    public IngressListFluent.ItemsNested<A> editFirstItem();
    public IngressListFluent.ItemsNested<A> editLastItem();
    public IngressListFluent.ItemsNested<A> editMatchingItem(Predicate<IngressBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressFluent<IngressListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
