package io.fabric8.kubernetes.api.model.networking.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class IngressServiceBackendFluentImpl<A extends IngressServiceBackendFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IngressServiceBackendFluent<A> {

    private String name;
    private ServiceBackendPortBuilder port;

    public IngressServiceBackendFluentImpl() {
    }

    public IngressServiceBackendFluentImpl(IngressServiceBackend instance) {
        this.withName(instance.getName()); 
        this.withPort(instance.getPort()); 
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public ServiceBackendPort getPort() {
        return this.port!=null?this.port.build():null;
    }

    public ServiceBackendPort buildPort() {
        return this.port!=null?this.port.build():null;
    }

    public A withPort(ServiceBackendPort port) {
        _visitables.get("port").remove(this.port);
        if (port!=null){ this.port= new ServiceBackendPortBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
    }

    public Boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(String name,Integer number) {
        return (A)withPort(new ServiceBackendPort(name, number));
    }

    public IngressServiceBackendFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    public IngressServiceBackendFluent.PortNested<A> withNewPortLike(ServiceBackendPort item) {
        return new PortNestedImpl(item);
    }

    public IngressServiceBackendFluent.PortNested<A> editPort() {
        return withNewPortLike(getPort());
    }

    public IngressServiceBackendFluent.PortNested<A> editOrNewPort() {
        return withNewPortLike(getPort() != null ? getPort(): new ServiceBackendPortBuilder().build());
    }

    public IngressServiceBackendFluent.PortNested<A> editOrNewPortLike(ServiceBackendPort item) {
        return withNewPortLike(getPort() != null ? getPort(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressServiceBackendFluentImpl that = (IngressServiceBackendFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  port,  super.hashCode());
    }

    public class PortNestedImpl<N> extends ServiceBackendPortFluentImpl<IngressServiceBackendFluent.PortNested<N>> implements IngressServiceBackendFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceBackendPortBuilder builder;

            PortNestedImpl(ServiceBackendPort item) {
                this.builder = new ServiceBackendPortBuilder(this, item);
                        
            }

            PortNestedImpl() {
                this.builder = new ServiceBackendPortBuilder(this);
                        
            }

            public N and() {
                return (N) IngressServiceBackendFluentImpl.this.withPort(builder.build());
            }

            public N endPort() {
                return and();
            }
    }


}
