package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressRuleBuilder extends io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluentImpl<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder> {

    io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent<?> fluent;
    Boolean validationEnabled;

    public IngressRuleBuilder() {
        this(true);
    }

    public IngressRuleBuilder(Boolean validationEnabled) {
        this(new IngressRule(), validationEnabled);
    }

    public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressRule(), validationEnabled);
    }

    public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule instance) {
        this(fluent, instance, true);
    }

    public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHost(instance.getHost()); 
        fluent.withHttp(instance.getHttp()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule instance) {
        this(instance,true);
    }

    public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHost(instance.getHost()); 
        this.withHttp(instance.getHttp()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule build() {
        IngressRule buildable = new IngressRule(fluent.getHost(),fluent.getHttp());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressRuleBuilder that = (IngressRuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
