/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackend;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpec;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>>
extends BaseFluent<A>
implements IngressSpecFluent<A> {
    private IngressBackendBuilder backend;
    private String ingressClassName;
    private List<IngressRuleBuilder> rules = new ArrayList<IngressRuleBuilder>();
    private List<IngressTLSBuilder> tls = new ArrayList<IngressTLSBuilder>();

    public IngressSpecFluentImpl() {
    }

    public IngressSpecFluentImpl(IngressSpec instance) {
        this.withBackend(instance.getBackend());
        this.withIngressClassName(instance.getIngressClassName());
        this.withRules(instance.getRules());
        this.withTls(instance.getTls());
    }

    @Override
    @Deprecated
    public IngressBackend getBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    @Override
    public IngressBackend buildBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    @Override
    public A withBackend(IngressBackend backend) {
        this._visitables.get((Object)"backend").remove(this.backend);
        if (backend != null) {
            this.backend = new IngressBackendBuilder(backend);
            this._visitables.get((Object)"backend").add(this.backend);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBackend() {
        return this.backend != null;
    }

    @Override
    public IngressSpecFluent.BackendNested<A> withNewBackend() {
        return new BackendNestedImpl();
    }

    @Override
    public IngressSpecFluent.BackendNested<A> withNewBackendLike(IngressBackend item) {
        return new BackendNestedImpl(item);
    }

    @Override
    public IngressSpecFluent.BackendNested<A> editBackend() {
        return this.withNewBackendLike(this.getBackend());
    }

    @Override
    public IngressSpecFluent.BackendNested<A> editOrNewBackend() {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : new IngressBackendBuilder().build());
    }

    @Override
    public IngressSpecFluent.BackendNested<A> editOrNewBackendLike(IngressBackend item) {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : item);
    }

    @Override
    public String getIngressClassName() {
        return this.ingressClassName;
    }

    @Override
    public A withIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return (A)this;
    }

    @Override
    public Boolean hasIngressClassName() {
        return this.ingressClassName != null;
    }

    @Override
    public A withNewIngressClassName(StringBuilder arg1) {
        return this.withIngressClassName(new String(arg1));
    }

    @Override
    public A withNewIngressClassName(int[] arg1, int arg2, int arg3) {
        return this.withIngressClassName(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewIngressClassName(char[] arg1) {
        return this.withIngressClassName(new String(arg1));
    }

    @Override
    public A withNewIngressClassName(StringBuffer arg1) {
        return this.withIngressClassName(new String(arg1));
    }

    @Override
    public A withNewIngressClassName(byte[] arg1, int arg2) {
        return this.withIngressClassName(new String(arg1, arg2));
    }

    @Override
    public A withNewIngressClassName(byte[] arg1) {
        return this.withIngressClassName(new String(arg1));
    }

    @Override
    public A withNewIngressClassName(char[] arg1, int arg2, int arg3) {
        return this.withIngressClassName(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewIngressClassName(byte[] arg1, int arg2, int arg3) {
        return this.withIngressClassName(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewIngressClassName(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withIngressClassName(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewIngressClassName(String arg1) {
        return this.withIngressClassName(new String(arg1));
    }

    @Override
    public A addToRules(int index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        this._visitables.get((Object)"rules").add(index >= 0 ? index : this._visitables.get((Object)"rules").size(), builder);
        this.rules.add(index >= 0 ? index : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(int index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"rules").size()) {
            this._visitables.get((Object)"rules").add(builder);
        } else {
            this._visitables.get((Object)"rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(IngressRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<IngressRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(IngressRule ... items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<IngressRule> items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<IngressRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<IngressRuleBuilder> each = this.rules.iterator();
        List visitables = this._visitables.get((Object)"rules");
        while (each.hasNext()) {
            IngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IngressRule> getRules() {
        return IngressSpecFluentImpl.build(this.rules);
    }

    @Override
    public List<IngressRule> buildRules() {
        return IngressSpecFluentImpl.build(this.rules);
    }

    @Override
    public IngressRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public IngressRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public IngressRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public IngressRule buildMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<IngressRule> rules) {
        if (this.rules != null) {
            this._visitables.get((Object)"rules").removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<IngressRuleBuilder>();
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(IngressRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public IngressSpecFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public IngressSpecFluent.RulesNested<A> addNewRuleLike(IngressRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public IngressSpecFluent.RulesNested<A> setNewRuleLike(int index, IngressRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public IngressSpecFluent.RulesNested<A> editMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public A addToTls(int index, IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        IngressTLSBuilder builder = new IngressTLSBuilder(item);
        this._visitables.get((Object)"tls").add(index >= 0 ? index : this._visitables.get((Object)"tls").size(), builder);
        this.tls.add(index >= 0 ? index : this.tls.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTls(int index, IngressTLS item) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        IngressTLSBuilder builder = new IngressTLSBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"tls").size()) {
            this._visitables.get((Object)"tls").add(builder);
        } else {
            this._visitables.get((Object)"tls").set(index, builder);
        }
        if (index < 0 || index >= this.tls.size()) {
            this.tls.add(builder);
        } else {
            this.tls.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTls(IngressTLS ... items) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTls(Collection<IngressTLS> items) {
        if (this.tls == null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
        }
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTls(IngressTLS ... items) {
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").remove(builder);
            if (this.tls == null) continue;
            this.tls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTls(Collection<IngressTLS> items) {
        for (IngressTLS item : items) {
            IngressTLSBuilder builder = new IngressTLSBuilder(item);
            this._visitables.get((Object)"tls").remove(builder);
            if (this.tls == null) continue;
            this.tls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTls(Predicate<IngressTLSBuilder> predicate) {
        if (this.tls == null) {
            return (A)this;
        }
        Iterator<IngressTLSBuilder> each = this.tls.iterator();
        List visitables = this._visitables.get((Object)"tls");
        while (each.hasNext()) {
            IngressTLSBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IngressTLS> getTls() {
        return IngressSpecFluentImpl.build(this.tls);
    }

    @Override
    public List<IngressTLS> buildTls() {
        return IngressSpecFluentImpl.build(this.tls);
    }

    @Override
    public IngressTLS buildTl(int index) {
        return this.tls.get(index).build();
    }

    @Override
    public IngressTLS buildFirstTl() {
        return this.tls.get(0).build();
    }

    @Override
    public IngressTLS buildLastTl() {
        return this.tls.get(this.tls.size() - 1).build();
    }

    @Override
    public IngressTLS buildMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        for (IngressTLSBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        for (IngressTLSBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTls(List<IngressTLS> tls) {
        if (this.tls != null) {
            this._visitables.get((Object)"tls").removeAll(this.tls);
        }
        if (tls != null) {
            this.tls = new ArrayList<IngressTLSBuilder>();
            for (IngressTLS item : tls) {
                this.addToTls(item);
            }
        } else {
            this.tls = null;
        }
        return (A)this;
    }

    @Override
    public A withTls(IngressTLS ... tls) {
        if (this.tls != null) {
            this.tls.clear();
        }
        if (tls != null) {
            for (IngressTLS item : tls) {
                this.addToTls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null && !this.tls.isEmpty();
    }

    @Override
    public IngressSpecFluent.TlsNested<A> addNewTl() {
        return new TlsNestedImpl();
    }

    @Override
    public IngressSpecFluent.TlsNested<A> addNewTlLike(IngressTLS item) {
        return new TlsNestedImpl(-1, item);
    }

    @Override
    public IngressSpecFluent.TlsNested<A> setNewTlLike(int index, IngressTLS item) {
        return new TlsNestedImpl(index, item);
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editTl(int index) {
        if (this.tls.size() <= index) {
            throw new RuntimeException("Can't edit tls. Index exceeds size.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editFirstTl() {
        if (this.tls.size() == 0) {
            throw new RuntimeException("Can't edit first tls. The list is empty.");
        }
        return this.setNewTlLike(0, this.buildTl(0));
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editLastTl() {
        int index = this.tls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tls. The list is empty.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    @Override
    public IngressSpecFluent.TlsNested<A> editMatchingTl(Predicate<IngressTLSBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tls.size(); ++i) {
            if (!predicate.test(this.tls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tls. No match found.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressSpecFluentImpl that = (IngressSpecFluentImpl)o;
        if (this.backend != null ? !this.backend.equals(that.backend) : that.backend != null) {
            return false;
        }
        if (this.ingressClassName != null ? !this.ingressClassName.equals(that.ingressClassName) : that.ingressClassName != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        return !(this.tls != null ? !this.tls.equals(that.tls) : that.tls != null);
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.ingressClassName, this.rules, this.tls, super.hashCode());
    }

    public class TlsNestedImpl<N>
    extends IngressTLSFluentImpl<IngressSpecFluent.TlsNested<N>>
    implements IngressSpecFluent.TlsNested<N>,
    Nested<N> {
        private final IngressTLSBuilder builder;
        private final int index;

        TlsNestedImpl(int index, IngressTLS item) {
            this.index = index;
            this.builder = new IngressTLSBuilder(this, item);
        }

        TlsNestedImpl() {
            this.index = -1;
            this.builder = new IngressTLSBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.setToTls(this.index, this.builder.build());
        }

        @Override
        public N endTl() {
            return this.and();
        }
    }

    public class RulesNestedImpl<N>
    extends IngressRuleFluentImpl<IngressSpecFluent.RulesNested<N>>
    implements IngressSpecFluent.RulesNested<N>,
    Nested<N> {
        private final IngressRuleBuilder builder;
        private final int index;

        RulesNestedImpl(int index, IngressRule item) {
            this.index = index;
            this.builder = new IngressRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new IngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class BackendNestedImpl<N>
    extends IngressBackendFluentImpl<IngressSpecFluent.BackendNested<N>>
    implements IngressSpecFluent.BackendNested<N>,
    Nested<N> {
        private final IngressBackendBuilder builder;

        BackendNestedImpl(IngressBackend item) {
            this.builder = new IngressBackendBuilder(this, item);
        }

        BackendNestedImpl() {
            this.builder = new IngressBackendBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressSpecFluentImpl.this.withBackend(this.builder.build());
        }

        @Override
        public N endBackend() {
            return this.and();
        }
    }
}

