package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HostPortRangeBuilder extends HostPortRangeFluentImpl<HostPortRangeBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<HostPortRange,HostPortRangeBuilder> {

    HostPortRangeFluent<?> fluent;
    Boolean validationEnabled;

    public HostPortRangeBuilder() {
        this(true);
    }

    public HostPortRangeBuilder(Boolean validationEnabled) {
        this(new HostPortRange(), validationEnabled);
    }

    public HostPortRangeBuilder(HostPortRangeFluent<?> fluent) {
        this(fluent, true);
    }

    public HostPortRangeBuilder(HostPortRangeFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new HostPortRange(), validationEnabled);
    }

    public HostPortRangeBuilder(HostPortRangeFluent<?> fluent,HostPortRange instance) {
        this(fluent, instance, true);
    }

    public HostPortRangeBuilder(HostPortRangeFluent<?> fluent,HostPortRange instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMax(instance.getMax()); 
        fluent.withMin(instance.getMin()); 
        this.validationEnabled = validationEnabled; 
    }

    public HostPortRangeBuilder(HostPortRange instance) {
        this(instance,true);
    }

    public HostPortRangeBuilder(HostPortRange instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withMax(instance.getMax()); 
        this.withMin(instance.getMin()); 
        this.validationEnabled = validationEnabled; 
    }

    public HostPortRange build() {
        HostPortRange buildable = new HostPortRange(fluent.getMax(),fluent.getMin());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HostPortRangeBuilder that = (HostPortRangeBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
