package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface RoleBindingListFluent<A extends RoleBindingListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,RoleBinding item);
    public A setToItems(int index,RoleBinding item);
    public A addToItems(RoleBinding... items);
    public A addAllToItems(Collection<RoleBinding> items);
    public A removeFromItems(RoleBinding... items);
    public A removeAllFromItems(Collection<RoleBinding> items);
    public A removeMatchingFromItems(Predicate<RoleBindingBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<RoleBinding> getItems();
    public List<RoleBinding> buildItems();
    public RoleBinding buildItem(int index);
    public RoleBinding buildFirstItem();
    public RoleBinding buildLastItem();
    public RoleBinding buildMatchingItem(Predicate<RoleBindingBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<RoleBindingBuilder> predicate);
    public A withItems(List<RoleBinding> items);
    public A withItems(RoleBinding... items);
    public Boolean hasItems();
    public RoleBindingListFluent.ItemsNested<A> addNewItem();
    public RoleBindingListFluent.ItemsNested<A> addNewItemLike(RoleBinding item);
    public RoleBindingListFluent.ItemsNested<A> setNewItemLike(int index,RoleBinding item);
    public RoleBindingListFluent.ItemsNested<A> editItem(int index);
    public RoleBindingListFluent.ItemsNested<A> editFirstItem();
    public RoleBindingListFluent.ItemsNested<A> editLastItem();
    public RoleBindingListFluent.ItemsNested<A> editMatchingItem(Predicate<RoleBindingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingFluent<RoleBindingListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
