package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface AggregationRuleFluent<A extends AggregationRuleFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToClusterRoleSelectors(int index,LabelSelector item);
    public A setToClusterRoleSelectors(int index,LabelSelector item);
    public A addToClusterRoleSelectors(LabelSelector... items);
    public A addAllToClusterRoleSelectors(Collection<LabelSelector> items);
    public A removeFromClusterRoleSelectors(LabelSelector... items);
    public A removeAllFromClusterRoleSelectors(Collection<LabelSelector> items);
    public A removeMatchingFromClusterRoleSelectors(Predicate<LabelSelectorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildClusterRoleSelectors instead.
 * @return The buildable object.
 */
@Deprecated public List<LabelSelector> getClusterRoleSelectors();
    public List<LabelSelector> buildClusterRoleSelectors();
    public LabelSelector buildClusterRoleSelector(int index);
    public LabelSelector buildFirstClusterRoleSelector();
    public LabelSelector buildLastClusterRoleSelector();
    public LabelSelector buildMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate);
    public Boolean hasMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate);
    public A withClusterRoleSelectors(List<LabelSelector> clusterRoleSelectors);
    public A withClusterRoleSelectors(LabelSelector... clusterRoleSelectors);
    public Boolean hasClusterRoleSelectors();
    public io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent.ClusterRoleSelectorsNested<A> addNewClusterRoleSelector();
    public io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent.ClusterRoleSelectorsNested<A> addNewClusterRoleSelectorLike(LabelSelector item);
    public io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent.ClusterRoleSelectorsNested<A> setNewClusterRoleSelectorLike(int index,LabelSelector item);
    public io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent.ClusterRoleSelectorsNested<A> editClusterRoleSelector(int index);
    public io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent.ClusterRoleSelectorsNested<A> editFirstClusterRoleSelector();
    public io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent.ClusterRoleSelectorsNested<A> editLastClusterRoleSelector();
    public io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent.ClusterRoleSelectorsNested<A> editMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate);
    public interface ClusterRoleSelectorsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<io.fabric8.kubernetes.api.model.rbac.AggregationRuleFluent.ClusterRoleSelectorsNested<N>> {

            public N and();
            public N endClusterRoleSelector();    }


}
