package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CSINodeListFluent<A extends CSINodeListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,CSINode item);
    public A setToItems(int index,CSINode item);
    public A addToItems(CSINode... items);
    public A addAllToItems(Collection<CSINode> items);
    public A removeFromItems(CSINode... items);
    public A removeAllFromItems(Collection<CSINode> items);
    public A removeMatchingFromItems(Predicate<CSINodeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<CSINode> getItems();
    public List<CSINode> buildItems();
    public CSINode buildItem(int index);
    public CSINode buildFirstItem();
    public CSINode buildLastItem();
    public CSINode buildMatchingItem(Predicate<CSINodeBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<CSINodeBuilder> predicate);
    public A withItems(List<CSINode> items);
    public A withItems(CSINode... items);
    public Boolean hasItems();
    public CSINodeListFluent.ItemsNested<A> addNewItem();
    public CSINodeListFluent.ItemsNested<A> addNewItemLike(CSINode item);
    public CSINodeListFluent.ItemsNested<A> setNewItemLike(int index,CSINode item);
    public CSINodeListFluent.ItemsNested<A> editItem(int index);
    public CSINodeListFluent.ItemsNested<A> editFirstItem();
    public CSINodeListFluent.ItemsNested<A> editLastItem();
    public CSINodeListFluent.ItemsNested<A> editMatchingItem(Predicate<CSINodeBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSINodeFluent<CSINodeListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
