package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class StorageClassBuilder extends io.fabric8.kubernetes.api.model.storage.StorageClassFluentImpl<io.fabric8.kubernetes.api.model.storage.StorageClassBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.storage.StorageClass,io.fabric8.kubernetes.api.model.storage.StorageClassBuilder>{
  public StorageClassBuilder() {
    this(false);
  }
  public StorageClassBuilder(java.lang.Boolean validationEnabled) {
    this(new StorageClass(), validationEnabled);
  }
  public StorageClassBuilder(io.fabric8.kubernetes.api.model.storage.StorageClassFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageClassBuilder(io.fabric8.kubernetes.api.model.storage.StorageClassFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new StorageClass(), validationEnabled);
  }
  public StorageClassBuilder(io.fabric8.kubernetes.api.model.storage.StorageClassFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.StorageClass instance) {
    this(fluent, instance, false);
  }
  public StorageClassBuilder(io.fabric8.kubernetes.api.model.storage.StorageClassFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.StorageClass instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowVolumeExpansion(instance.getAllowVolumeExpansion()); 
    fluent.withAllowedTopologies(instance.getAllowedTopologies()); 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withMountOptions(instance.getMountOptions()); 
    fluent.withParameters(instance.getParameters()); 
    fluent.withProvisioner(instance.getProvisioner()); 
    fluent.withReclaimPolicy(instance.getReclaimPolicy()); 
    fluent.withVolumeBindingMode(instance.getVolumeBindingMode()); 
    this.validationEnabled = validationEnabled; 
  }
  public StorageClassBuilder(io.fabric8.kubernetes.api.model.storage.StorageClass instance) {
    this(instance,false);
  }
  public StorageClassBuilder(io.fabric8.kubernetes.api.model.storage.StorageClass instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion()); 
    this.withAllowedTopologies(instance.getAllowedTopologies()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withMountOptions(instance.getMountOptions()); 
    this.withParameters(instance.getParameters()); 
    this.withProvisioner(instance.getProvisioner()); 
    this.withReclaimPolicy(instance.getReclaimPolicy()); 
    this.withVolumeBindingMode(instance.getVolumeBindingMode()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.storage.StorageClassFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.storage.StorageClass build() {
    StorageClass buildable = new StorageClass(fluent.getAllowVolumeExpansion(),fluent.getAllowedTopologies(),fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getMountOptions(),fluent.getParameters(),fluent.getProvisioner(),fluent.getReclaimPolicy(),fluent.getVolumeBindingMode());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StorageClassBuilder that = (StorageClassBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}