package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class BuildRequestBuilder extends BuildRequestFluent<BuildRequestBuilder> implements VisitableBuilder<BuildRequest,BuildRequestBuilder>{

     BuildRequestFluent<?> fluent;
public BuildRequestBuilder(){
    this(new BuildRequest());
}
public BuildRequestBuilder( BuildRequestFluent<?> fluent ){
    this(fluent, new BuildRequest());
}
public BuildRequestBuilder( BuildRequestFluent<?> fluent , BuildRequest instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withRevision(instance.getRevision()); fluent.withTriggeredByImage(instance.getTriggeredByImage()); 
}
public BuildRequestBuilder( BuildRequest instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRevision(instance.getRevision()); this.withTriggeredByImage(instance.getTriggeredByImage()); 
}

public EditableBuildRequest build(){
    EditableBuildRequest buildable = new EditableBuildRequest(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRevision(),fluent.getTriggeredByImage());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    