package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ExecNewPodHookBuilder extends ExecNewPodHookFluent<ExecNewPodHookBuilder> implements VisitableBuilder<ExecNewPodHook,ExecNewPodHookBuilder>{

     ExecNewPodHookFluent<?> fluent;
public ExecNewPodHookBuilder(){
    this(new ExecNewPodHook());
}
public ExecNewPodHookBuilder( ExecNewPodHookFluent<?> fluent ){
    this(fluent, new ExecNewPodHook());
}
public ExecNewPodHookBuilder( ExecNewPodHookFluent<?> fluent , ExecNewPodHook instance ){
    this.fluent = fluent; fluent.withCommand(instance.getCommand()); fluent.withContainerName(instance.getContainerName()); fluent.withEnv(instance.getEnv()); 
}
public ExecNewPodHookBuilder( ExecNewPodHook instance ){
    this.fluent = this; this.withCommand(instance.getCommand()); this.withContainerName(instance.getContainerName()); this.withEnv(instance.getEnv()); 
}

public EditableExecNewPodHook build(){
    EditableExecNewPodHook buildable = new EditableExecNewPodHook(fluent.getCommand(),fluent.getContainerName(),fluent.getEnv());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    