package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class TagEventBuilder extends TagEventFluent<TagEventBuilder> implements VisitableBuilder<TagEvent,TagEventBuilder>{

     TagEventFluent<?> fluent;
public TagEventBuilder(){
    this(new TagEvent());
}
public TagEventBuilder( TagEventFluent<?> fluent ){
    this(fluent, new TagEvent());
}
public TagEventBuilder( TagEventFluent<?> fluent , TagEvent instance ){
    this.fluent = fluent; fluent.withCreated(instance.getCreated()); fluent.withDockerImageReference(instance.getDockerImageReference()); fluent.withImage(instance.getImage()); 
}
public TagEventBuilder( TagEvent instance ){
    this.fluent = this; this.withCreated(instance.getCreated()); this.withDockerImageReference(instance.getDockerImageReference()); this.withImage(instance.getImage()); 
}

public EditableTagEvent build(){
    EditableTagEvent buildable = new EditableTagEvent(fluent.getCreated(),fluent.getDockerImageReference(),fluent.getImage());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    