
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "containerID",
    "image",
    "imageID",
    "lastState",
    "name",
    "ready",
    "restartCount",
    "state"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class ContainerStatus {

    /**
     * container's ID in the format 'docker://<container_id>'
     * 
     */
    @JsonProperty("containerID")
    private String containerID;
    /**
     * image of the container
     * 
     */
    @JsonProperty("image")
    private String image;
    /**
     * ID of the container's image
     * 
     */
    @JsonProperty("imageID")
    private String imageID;
    /**
     * 
     * 
     */
    @JsonProperty("lastState")
    @Valid
    private ContainerState lastState;
    /**
     * name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated
     * 
     */
    @JsonProperty("name")
    @Pattern(regexp = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?$")
    @Size(max = 63)
    private String name;
    /**
     * specifies whether the container has passed its readiness probe
     * 
     */
    @JsonProperty("ready")
    private Boolean ready;
    /**
     * the number of times the container has been restarted
     * 
     */
    @JsonProperty("restartCount")
    private Integer restartCount;
    /**
     * 
     * 
     */
    @JsonProperty("state")
    @Valid
    private ContainerState state;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ContainerStatus() {
    }

    /**
     * 
     * @param imageID
     * @param name
     * @param state
     * @param image
     * @param lastState
     * @param ready
     * @param restartCount
     * @param containerID
     */
    public ContainerStatus(String containerID, String image, String imageID, ContainerState lastState, String name, Boolean ready, Integer restartCount, ContainerState state) {
        this.containerID = containerID;
        this.image = image;
        this.imageID = imageID;
        this.lastState = lastState;
        this.name = name;
        this.ready = ready;
        this.restartCount = restartCount;
        this.state = state;
    }

    /**
     * container's ID in the format 'docker://<container_id>'
     * 
     * @return
     *     The containerID
     */
    @JsonProperty("containerID")
    public String getContainerID() {
        return containerID;
    }

    /**
     * container's ID in the format 'docker://<container_id>'
     * 
     * @param containerID
     *     The containerID
     */
    @JsonProperty("containerID")
    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    /**
     * image of the container
     * 
     * @return
     *     The image
     */
    @JsonProperty("image")
    public String getImage() {
        return image;
    }

    /**
     * image of the container
     * 
     * @param image
     *     The image
     */
    @JsonProperty("image")
    public void setImage(String image) {
        this.image = image;
    }

    /**
     * ID of the container's image
     * 
     * @return
     *     The imageID
     */
    @JsonProperty("imageID")
    public String getImageID() {
        return imageID;
    }

    /**
     * ID of the container's image
     * 
     * @param imageID
     *     The imageID
     */
    @JsonProperty("imageID")
    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    /**
     * 
     * 
     * @return
     *     The lastState
     */
    @JsonProperty("lastState")
    public ContainerState getLastState() {
        return lastState;
    }

    /**
     * 
     * 
     * @param lastState
     *     The lastState
     */
    @JsonProperty("lastState")
    public void setLastState(ContainerState lastState) {
        this.lastState = lastState;
    }

    /**
     * name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * name of the container; must be a DNS_LABEL and unique within the pod; cannot be updated
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * specifies whether the container has passed its readiness probe
     * 
     * @return
     *     The ready
     */
    @JsonProperty("ready")
    public Boolean getReady() {
        return ready;
    }

    /**
     * specifies whether the container has passed its readiness probe
     * 
     * @param ready
     *     The ready
     */
    @JsonProperty("ready")
    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    /**
     * the number of times the container has been restarted
     * 
     * @return
     *     The restartCount
     */
    @JsonProperty("restartCount")
    public Integer getRestartCount() {
        return restartCount;
    }

    /**
     * the number of times the container has been restarted
     * 
     * @param restartCount
     *     The restartCount
     */
    @JsonProperty("restartCount")
    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    /**
     * 
     * 
     * @return
     *     The state
     */
    @JsonProperty("state")
    public ContainerState getState() {
        return state;
    }

    /**
     * 
     * 
     * @param state
     *     The state
     */
    @JsonProperty("state")
    public void setState(ContainerState state) {
        this.state = state;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(containerID).append(image).append(imageID).append(lastState).append(name).append(ready).append(restartCount).append(state).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ContainerStatus) == false) {
            return false;
        }
        ContainerStatus rhs = ((ContainerStatus) other);
        return new EqualsBuilder().append(containerID, rhs.containerID).append(image, rhs.image).append(imageID, rhs.imageID).append(lastState, rhs.lastState).append(name, rhs.name).append(ready, rhs.ready).append(restartCount, rhs.restartCount).append(state, rhs.state).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
