package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class EnvVarSourceBuilder extends EnvVarSourceFluent<EnvVarSourceBuilder> implements VisitableBuilder<EnvVarSource,EnvVarSourceBuilder>{

     EnvVarSourceFluent<?> fluent;
public EnvVarSourceBuilder(){
    this(new EnvVarSource());
}
public EnvVarSourceBuilder( EnvVarSourceFluent<?> fluent ){
    this(fluent, new EnvVarSource());
}
public EnvVarSourceBuilder( EnvVarSourceFluent<?> fluent , EnvVarSource instance ){
    this.fluent = fluent; fluent.withFieldRef(instance.getFieldRef()); 
}
public EnvVarSourceBuilder( EnvVarSource instance ){
    this.fluent = this; this.withFieldRef(instance.getFieldRef()); 
}

public EditableEnvVarSource build(){
    EditableEnvVarSource buildable = new EditableEnvVarSource(fluent.getFieldRef());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    