package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class NodeStatusBuilder extends NodeStatusFluent<NodeStatusBuilder> implements VisitableBuilder<NodeStatus,NodeStatusBuilder>{

     NodeStatusFluent<?> fluent;
public NodeStatusBuilder(){
    this(new NodeStatus());
}
public NodeStatusBuilder( NodeStatusFluent<?> fluent ){
    this(fluent, new NodeStatus());
}
public NodeStatusBuilder( NodeStatusFluent<?> fluent , NodeStatus instance ){
    this.fluent = fluent; fluent.withAddresses(instance.getAddresses()); fluent.withCapacity(instance.getCapacity()); fluent.withConditions(instance.getConditions()); fluent.withNodeInfo(instance.getNodeInfo()); fluent.withPhase(instance.getPhase()); 
}
public NodeStatusBuilder( NodeStatus instance ){
    this.fluent = this; this.withAddresses(instance.getAddresses()); this.withCapacity(instance.getCapacity()); this.withConditions(instance.getConditions()); this.withNodeInfo(instance.getNodeInfo()); this.withPhase(instance.getPhase()); 
}

public EditableNodeStatus build(){
    EditableNodeStatus buildable = new EditableNodeStatus(fluent.getAddresses(),fluent.getCapacity(),fluent.getConditions(),fluent.getNodeInfo(),fluent.getPhase());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    