
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "bootID",
    "containerRuntimeVersion",
    "kernelVersion",
    "kubeProxyVersion",
    "kubeletVersion",
    "machineID",
    "osImage",
    "systemUUID"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class NodeSystemInfo {

    /**
     * boot id is the boot-id reported by the node
     * 
     */
    @JsonProperty("bootID")
    private String bootID;
    /**
     * Container runtime version reported by the node through runtime remote API (e.g. docker://1.5.0)
     * 
     */
    @JsonProperty("containerRuntimeVersion")
    private String containerRuntimeVersion;
    /**
     * Kernel version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64)
     * 
     */
    @JsonProperty("kernelVersion")
    private String kernelVersion;
    /**
     * Kube-proxy version reported by the node
     * 
     */
    @JsonProperty("kubeProxyVersion")
    private String kubeProxyVersion;
    /**
     * Kubelet version reported by the node
     * 
     */
    @JsonProperty("kubeletVersion")
    private String kubeletVersion;
    /**
     * machine-id reported by the node
     * 
     */
    @JsonProperty("machineID")
    private String machineID;
    /**
     * OS image used reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy))
     * 
     */
    @JsonProperty("osImage")
    private String osImage;
    /**
     * system-uuid reported by the node
     * 
     */
    @JsonProperty("systemUUID")
    private String systemUUID;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public NodeSystemInfo() {
    }

    /**
     * 
     * @param bootID
     * @param systemUUID
     * @param kubeletVersion
     * @param osImage
     * @param kubeProxyVersion
     * @param kernelVersion
     * @param machineID
     * @param containerRuntimeVersion
     */
    public NodeSystemInfo(String bootID, String containerRuntimeVersion, String kernelVersion, String kubeProxyVersion, String kubeletVersion, String machineID, String osImage, String systemUUID) {
        this.bootID = bootID;
        this.containerRuntimeVersion = containerRuntimeVersion;
        this.kernelVersion = kernelVersion;
        this.kubeProxyVersion = kubeProxyVersion;
        this.kubeletVersion = kubeletVersion;
        this.machineID = machineID;
        this.osImage = osImage;
        this.systemUUID = systemUUID;
    }

    /**
     * boot id is the boot-id reported by the node
     * 
     * @return
     *     The bootID
     */
    @JsonProperty("bootID")
    public String getBootID() {
        return bootID;
    }

    /**
     * boot id is the boot-id reported by the node
     * 
     * @param bootID
     *     The bootID
     */
    @JsonProperty("bootID")
    public void setBootID(String bootID) {
        this.bootID = bootID;
    }

    /**
     * Container runtime version reported by the node through runtime remote API (e.g. docker://1.5.0)
     * 
     * @return
     *     The containerRuntimeVersion
     */
    @JsonProperty("containerRuntimeVersion")
    public String getContainerRuntimeVersion() {
        return containerRuntimeVersion;
    }

    /**
     * Container runtime version reported by the node through runtime remote API (e.g. docker://1.5.0)
     * 
     * @param containerRuntimeVersion
     *     The containerRuntimeVersion
     */
    @JsonProperty("containerRuntimeVersion")
    public void setContainerRuntimeVersion(String containerRuntimeVersion) {
        this.containerRuntimeVersion = containerRuntimeVersion;
    }

    /**
     * Kernel version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64)
     * 
     * @return
     *     The kernelVersion
     */
    @JsonProperty("kernelVersion")
    public String getKernelVersion() {
        return kernelVersion;
    }

    /**
     * Kernel version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64)
     * 
     * @param kernelVersion
     *     The kernelVersion
     */
    @JsonProperty("kernelVersion")
    public void setKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    /**
     * Kube-proxy version reported by the node
     * 
     * @return
     *     The kubeProxyVersion
     */
    @JsonProperty("kubeProxyVersion")
    public String getKubeProxyVersion() {
        return kubeProxyVersion;
    }

    /**
     * Kube-proxy version reported by the node
     * 
     * @param kubeProxyVersion
     *     The kubeProxyVersion
     */
    @JsonProperty("kubeProxyVersion")
    public void setKubeProxyVersion(String kubeProxyVersion) {
        this.kubeProxyVersion = kubeProxyVersion;
    }

    /**
     * Kubelet version reported by the node
     * 
     * @return
     *     The kubeletVersion
     */
    @JsonProperty("kubeletVersion")
    public String getKubeletVersion() {
        return kubeletVersion;
    }

    /**
     * Kubelet version reported by the node
     * 
     * @param kubeletVersion
     *     The kubeletVersion
     */
    @JsonProperty("kubeletVersion")
    public void setKubeletVersion(String kubeletVersion) {
        this.kubeletVersion = kubeletVersion;
    }

    /**
     * machine-id reported by the node
     * 
     * @return
     *     The machineID
     */
    @JsonProperty("machineID")
    public String getMachineID() {
        return machineID;
    }

    /**
     * machine-id reported by the node
     * 
     * @param machineID
     *     The machineID
     */
    @JsonProperty("machineID")
    public void setMachineID(String machineID) {
        this.machineID = machineID;
    }

    /**
     * OS image used reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy))
     * 
     * @return
     *     The osImage
     */
    @JsonProperty("osImage")
    public String getOsImage() {
        return osImage;
    }

    /**
     * OS image used reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy))
     * 
     * @param osImage
     *     The osImage
     */
    @JsonProperty("osImage")
    public void setOsImage(String osImage) {
        this.osImage = osImage;
    }

    /**
     * system-uuid reported by the node
     * 
     * @return
     *     The systemUUID
     */
    @JsonProperty("systemUUID")
    public String getSystemUUID() {
        return systemUUID;
    }

    /**
     * system-uuid reported by the node
     * 
     * @param systemUUID
     *     The systemUUID
     */
    @JsonProperty("systemUUID")
    public void setSystemUUID(String systemUUID) {
        this.systemUUID = systemUUID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(bootID).append(containerRuntimeVersion).append(kernelVersion).append(kubeProxyVersion).append(kubeletVersion).append(machineID).append(osImage).append(systemUUID).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof NodeSystemInfo) == false) {
            return false;
        }
        NodeSystemInfo rhs = ((NodeSystemInfo) other);
        return new EqualsBuilder().append(bootID, rhs.bootID).append(containerRuntimeVersion, rhs.containerRuntimeVersion).append(kernelVersion, rhs.kernelVersion).append(kubeProxyVersion, rhs.kubeProxyVersion).append(kubeletVersion, rhs.kubeletVersion).append(machineID, rhs.machineID).append(osImage, rhs.osImage).append(systemUUID, rhs.systemUUID).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
