
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "accessModes",
    "awsElasticBlockStore",
    "capacity",
    "claimRef",
    "gcePersistentDisk",
    "glusterfs",
    "hostPath",
    "iscsi",
    "nfs",
    "persistentVolumeReclaimPolicy",
    "rbd"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class PersistentVolumeSpec {

    /**
     * all ways the volume can be mounted
     * 
     */
    @JsonProperty("accessModes")
    @Valid
    private List<java.lang.String> accessModes = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("awsElasticBlockStore")
    @Valid
    private AWSElasticBlockStoreVolumeSource awsElasticBlockStore;
    /**
     * a description of the persistent volume's resources and capacity
     * 
     */
    @JsonProperty("capacity")
    @Valid
    private Map<String, Quantity> capacity;
    /**
     * 
     * 
     */
    @JsonProperty("claimRef")
    @Valid
    private ObjectReference claimRef;
    /**
     * 
     * 
     */
    @JsonProperty("gcePersistentDisk")
    @Valid
    private GCEPersistentDiskVolumeSource gcePersistentDisk;
    /**
     * 
     * 
     */
    @JsonProperty("glusterfs")
    @Valid
    private GlusterfsVolumeSource glusterfs;
    /**
     * 
     * 
     */
    @JsonProperty("hostPath")
    @Valid
    private HostPathVolumeSource hostPath;
    /**
     * 
     * 
     */
    @JsonProperty("iscsi")
    @Valid
    private ISCSIVolumeSource iscsi;
    /**
     * 
     * 
     */
    @JsonProperty("nfs")
    @Valid
    private NFSVolumeSource nfs;
    /**
     * what happens to a volume when released from its claim; Valid options are Retain (default) and Recycle.  Recyling must be supported by the volume plugin underlying this persistent volume.
     * 
     */
    @JsonProperty("persistentVolumeReclaimPolicy")
    private java.lang.String persistentVolumeReclaimPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("rbd")
    @Valid
    private RBDVolumeSource rbd;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PersistentVolumeSpec() {
    }

    /**
     * 
     * @param iscsi
     * @param accessModes
     * @param persistentVolumeReclaimPolicy
     * @param gcePersistentDisk
     * @param glusterfs
     * @param nfs
     * @param hostPath
     * @param claimRef
     * @param capacity
     * @param rbd
     * @param awsElasticBlockStore
     */
    public PersistentVolumeSpec(List<java.lang.String> accessModes, AWSElasticBlockStoreVolumeSource awsElasticBlockStore, Map<String, Quantity> capacity, ObjectReference claimRef, GCEPersistentDiskVolumeSource gcePersistentDisk, GlusterfsVolumeSource glusterfs, HostPathVolumeSource hostPath, ISCSIVolumeSource iscsi, NFSVolumeSource nfs, java.lang.String persistentVolumeReclaimPolicy, RBDVolumeSource rbd) {
        this.accessModes = accessModes;
        this.awsElasticBlockStore = awsElasticBlockStore;
        this.capacity = capacity;
        this.claimRef = claimRef;
        this.gcePersistentDisk = gcePersistentDisk;
        this.glusterfs = glusterfs;
        this.hostPath = hostPath;
        this.iscsi = iscsi;
        this.nfs = nfs;
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
        this.rbd = rbd;
    }

    /**
     * all ways the volume can be mounted
     * 
     * @return
     *     The accessModes
     */
    @JsonProperty("accessModes")
    public List<java.lang.String> getAccessModes() {
        return accessModes;
    }

    /**
     * all ways the volume can be mounted
     * 
     * @param accessModes
     *     The accessModes
     */
    @JsonProperty("accessModes")
    public void setAccessModes(List<java.lang.String> accessModes) {
        this.accessModes = accessModes;
    }

    /**
     * 
     * 
     * @return
     *     The awsElasticBlockStore
     */
    @JsonProperty("awsElasticBlockStore")
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return awsElasticBlockStore;
    }

    /**
     * 
     * 
     * @param awsElasticBlockStore
     *     The awsElasticBlockStore
     */
    @JsonProperty("awsElasticBlockStore")
    public void setAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        this.awsElasticBlockStore = awsElasticBlockStore;
    }

    /**
     * a description of the persistent volume's resources and capacity
     * 
     * @return
     *     The capacity
     */
    @JsonProperty("capacity")
    public Map<String, Quantity> getCapacity() {
        return capacity;
    }

    /**
     * a description of the persistent volume's resources and capacity
     * 
     * @param capacity
     *     The capacity
     */
    @JsonProperty("capacity")
    public void setCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
    }

    /**
     * 
     * 
     * @return
     *     The claimRef
     */
    @JsonProperty("claimRef")
    public ObjectReference getClaimRef() {
        return claimRef;
    }

    /**
     * 
     * 
     * @param claimRef
     *     The claimRef
     */
    @JsonProperty("claimRef")
    public void setClaimRef(ObjectReference claimRef) {
        this.claimRef = claimRef;
    }

    /**
     * 
     * 
     * @return
     *     The gcePersistentDisk
     */
    @JsonProperty("gcePersistentDisk")
    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return gcePersistentDisk;
    }

    /**
     * 
     * 
     * @param gcePersistentDisk
     *     The gcePersistentDisk
     */
    @JsonProperty("gcePersistentDisk")
    public void setGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        this.gcePersistentDisk = gcePersistentDisk;
    }

    /**
     * 
     * 
     * @return
     *     The glusterfs
     */
    @JsonProperty("glusterfs")
    public GlusterfsVolumeSource getGlusterfs() {
        return glusterfs;
    }

    /**
     * 
     * 
     * @param glusterfs
     *     The glusterfs
     */
    @JsonProperty("glusterfs")
    public void setGlusterfs(GlusterfsVolumeSource glusterfs) {
        this.glusterfs = glusterfs;
    }

    /**
     * 
     * 
     * @return
     *     The hostPath
     */
    @JsonProperty("hostPath")
    public HostPathVolumeSource getHostPath() {
        return hostPath;
    }

    /**
     * 
     * 
     * @param hostPath
     *     The hostPath
     */
    @JsonProperty("hostPath")
    public void setHostPath(HostPathVolumeSource hostPath) {
        this.hostPath = hostPath;
    }

    /**
     * 
     * 
     * @return
     *     The iscsi
     */
    @JsonProperty("iscsi")
    public ISCSIVolumeSource getIscsi() {
        return iscsi;
    }

    /**
     * 
     * 
     * @param iscsi
     *     The iscsi
     */
    @JsonProperty("iscsi")
    public void setIscsi(ISCSIVolumeSource iscsi) {
        this.iscsi = iscsi;
    }

    /**
     * 
     * 
     * @return
     *     The nfs
     */
    @JsonProperty("nfs")
    public NFSVolumeSource getNfs() {
        return nfs;
    }

    /**
     * 
     * 
     * @param nfs
     *     The nfs
     */
    @JsonProperty("nfs")
    public void setNfs(NFSVolumeSource nfs) {
        this.nfs = nfs;
    }

    /**
     * what happens to a volume when released from its claim; Valid options are Retain (default) and Recycle.  Recyling must be supported by the volume plugin underlying this persistent volume.
     * 
     * @return
     *     The persistentVolumeReclaimPolicy
     */
    @JsonProperty("persistentVolumeReclaimPolicy")
    public java.lang.String getPersistentVolumeReclaimPolicy() {
        return persistentVolumeReclaimPolicy;
    }

    /**
     * what happens to a volume when released from its claim; Valid options are Retain (default) and Recycle.  Recyling must be supported by the volume plugin underlying this persistent volume.
     * 
     * @param persistentVolumeReclaimPolicy
     *     The persistentVolumeReclaimPolicy
     */
    @JsonProperty("persistentVolumeReclaimPolicy")
    public void setPersistentVolumeReclaimPolicy(java.lang.String persistentVolumeReclaimPolicy) {
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The rbd
     */
    @JsonProperty("rbd")
    public RBDVolumeSource getRbd() {
        return rbd;
    }

    /**
     * 
     * 
     * @param rbd
     *     The rbd
     */
    @JsonProperty("rbd")
    public void setRbd(RBDVolumeSource rbd) {
        this.rbd = rbd;
    }

    @Override
    public java.lang.String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(accessModes).append(awsElasticBlockStore).append(capacity).append(claimRef).append(gcePersistentDisk).append(glusterfs).append(hostPath).append(iscsi).append(nfs).append(persistentVolumeReclaimPolicy).append(rbd).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PersistentVolumeSpec) == false) {
            return false;
        }
        PersistentVolumeSpec rhs = ((PersistentVolumeSpec) other);
        return new EqualsBuilder().append(accessModes, rhs.accessModes).append(awsElasticBlockStore, rhs.awsElasticBlockStore).append(capacity, rhs.capacity).append(claimRef, rhs.claimRef).append(gcePersistentDisk, rhs.gcePersistentDisk).append(glusterfs, rhs.glusterfs).append(hostPath, rhs.hostPath).append(iscsi, rhs.iscsi).append(nfs, rhs.nfs).append(persistentVolumeReclaimPolicy, rhs.persistentVolumeReclaimPolicy).append(rbd, rhs.rbd).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
