package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class PersistentVolumeSpecBuilder extends PersistentVolumeSpecFluent<PersistentVolumeSpecBuilder> implements VisitableBuilder<PersistentVolumeSpec,PersistentVolumeSpecBuilder>{

     PersistentVolumeSpecFluent<?> fluent;
public PersistentVolumeSpecBuilder(){
    this(new PersistentVolumeSpec());
}
public PersistentVolumeSpecBuilder( PersistentVolumeSpecFluent<?> fluent ){
    this(fluent, new PersistentVolumeSpec());
}
public PersistentVolumeSpecBuilder( PersistentVolumeSpecFluent<?> fluent , PersistentVolumeSpec instance ){
    this.fluent = fluent; fluent.withAccessModes(instance.getAccessModes()); fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); fluent.withCapacity(instance.getCapacity()); fluent.withClaimRef(instance.getClaimRef()); fluent.withGcePersistentDisk(instance.getGcePersistentDisk()); fluent.withGlusterfs(instance.getGlusterfs()); fluent.withHostPath(instance.getHostPath()); fluent.withIscsi(instance.getIscsi()); fluent.withNfs(instance.getNfs()); fluent.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy()); fluent.withRbd(instance.getRbd()); 
}
public PersistentVolumeSpecBuilder( PersistentVolumeSpec instance ){
    this.fluent = this; this.withAccessModes(instance.getAccessModes()); this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); this.withCapacity(instance.getCapacity()); this.withClaimRef(instance.getClaimRef()); this.withGcePersistentDisk(instance.getGcePersistentDisk()); this.withGlusterfs(instance.getGlusterfs()); this.withHostPath(instance.getHostPath()); this.withIscsi(instance.getIscsi()); this.withNfs(instance.getNfs()); this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy()); this.withRbd(instance.getRbd()); 
}

public EditablePersistentVolumeSpec build(){
    EditablePersistentVolumeSpec buildable = new EditablePersistentVolumeSpec(fluent.getAccessModes(),fluent.getAwsElasticBlockStore(),fluent.getCapacity(),fluent.getClaimRef(),fluent.getGcePersistentDisk(),fluent.getGlusterfs(),fluent.getHostPath(),fluent.getIscsi(),fluent.getNfs(),fluent.getPersistentVolumeReclaimPolicy(),fluent.getRbd());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    