
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "name",
    "nodePort",
    "port",
    "protocol",
    "targetPort"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class ServicePort {

    /**
     * the name of this port; optional if only one port is defined
     * 
     */
    @JsonProperty("name")
    @Pattern(regexp = "^[a-z0-9]([-a-z0-9]*[a-z0-9])?$")
    @Size(max = 63)
    private String name;
    /**
     * the port on each node on which this service is exposed when type=NodePort or LoadBalancer; usually assigned by the system; if specified
     * 
     */
    @JsonProperty("nodePort")
    private Integer nodePort;
    /**
     * the port number that is exposed
     * 
     */
    @JsonProperty("port")
    private Integer port;
    /**
     * the protocol used by this port; must be UDP or TCP; TCP if unspecified
     * 
     */
    @JsonProperty("protocol")
    private String protocol;
    /**
     * 
     * 
     */
    @JsonProperty("targetPort")
    @Valid
    private IntOrString targetPort;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServicePort() {
    }

    /**
     * 
     * @param port
     * @param protocol
     * @param nodePort
     * @param targetPort
     * @param name
     */
    public ServicePort(String name, Integer nodePort, Integer port, String protocol, IntOrString targetPort) {
        this.name = name;
        this.nodePort = nodePort;
        this.port = port;
        this.protocol = protocol;
        this.targetPort = targetPort;
    }

    /**
     * the name of this port; optional if only one port is defined
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * the name of this port; optional if only one port is defined
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * the port on each node on which this service is exposed when type=NodePort or LoadBalancer; usually assigned by the system; if specified
     * 
     * @return
     *     The nodePort
     */
    @JsonProperty("nodePort")
    public Integer getNodePort() {
        return nodePort;
    }

    /**
     * the port on each node on which this service is exposed when type=NodePort or LoadBalancer; usually assigned by the system; if specified
     * 
     * @param nodePort
     *     The nodePort
     */
    @JsonProperty("nodePort")
    public void setNodePort(Integer nodePort) {
        this.nodePort = nodePort;
    }

    /**
     * the port number that is exposed
     * 
     * @return
     *     The port
     */
    @JsonProperty("port")
    public Integer getPort() {
        return port;
    }

    /**
     * the port number that is exposed
     * 
     * @param port
     *     The port
     */
    @JsonProperty("port")
    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * the protocol used by this port; must be UDP or TCP; TCP if unspecified
     * 
     * @return
     *     The protocol
     */
    @JsonProperty("protocol")
    public String getProtocol() {
        return protocol;
    }

    /**
     * the protocol used by this port; must be UDP or TCP; TCP if unspecified
     * 
     * @param protocol
     *     The protocol
     */
    @JsonProperty("protocol")
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /**
     * 
     * 
     * @return
     *     The targetPort
     */
    @JsonProperty("targetPort")
    public IntOrString getTargetPort() {
        return targetPort;
    }

    /**
     * 
     * 
     * @param targetPort
     *     The targetPort
     */
    @JsonProperty("targetPort")
    public void setTargetPort(IntOrString targetPort) {
        this.targetPort = targetPort;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).append(nodePort).append(port).append(protocol).append(targetPort).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ServicePort) == false) {
            return false;
        }
        ServicePort rhs = ((ServicePort) other);
        return new EqualsBuilder().append(name, rhs.name).append(nodePort, rhs.nodePort).append(port, rhs.port).append(protocol, rhs.protocol).append(targetPort, rhs.targetPort).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
