/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentImpl;
import io.fabric8.kubernetes.api.model.EditableContainerStateWaiting;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStateWaitingBuilder
extends ContainerStateWaitingFluentImpl<ContainerStateWaitingBuilder>
implements VisitableBuilder<ContainerStateWaiting, ContainerStateWaitingBuilder> {
    ContainerStateWaitingFluent<?> fluent;

    public ContainerStateWaitingBuilder() {
        this(new ContainerStateWaiting());
    }

    public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent) {
        this(fluent, new ContainerStateWaiting());
    }

    public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent, ContainerStateWaiting instance) {
        this.fluent = fluent;
        fluent.withReason(instance.getReason());
    }

    public ContainerStateWaitingBuilder(ContainerStateWaiting instance) {
        this.fluent = this;
        this.withReason(instance.getReason());
    }

    @Override
    public EditableContainerStateWaiting build() {
        EditableContainerStateWaiting buildable = new EditableContainerStateWaiting(this.fluent.getReason());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateWaitingBuilder that = (ContainerStateWaitingBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

