package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class AuthInfoFluentImpl<T extends AuthInfoFluent<T>> extends BaseFluent<T> implements AuthInfoFluent<T>{

     String clientCertificate;     String clientCertificateData;     String clientKey;     String clientKeyData;     List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();     String password;     String token;     String username;     Map<String, Object> additionalProperties = new HashMap();

    public String getClientCertificate(){
    return this.clientCertificate;
    }
    public T withClientCertificate( String clientCertificate){
    this.clientCertificate=clientCertificate; return (T) this;
    }
    public String getClientCertificateData(){
    return this.clientCertificateData;
    }
    public T withClientCertificateData( String clientCertificateData){
    this.clientCertificateData=clientCertificateData; return (T) this;
    }
    public String getClientKey(){
    return this.clientKey;
    }
    public T withClientKey( String clientKey){
    this.clientKey=clientKey; return (T) this;
    }
    public String getClientKeyData(){
    return this.clientKeyData;
    }
    public T withClientKeyData( String clientKeyData){
    this.clientKeyData=clientKeyData; return (T) this;
    }
    public T addToExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (T)this;
    }
    public T removeFromExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (T)this;
    }
    public List<NamedExtension> getExtensions(){
    return build(extensions);
    }
    public T withExtensions( List<NamedExtension> extensions){
    this.extensions.clear();if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (T) this;
    }
    public T withExtensions( NamedExtension ...extensions){
    this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (T) this;
    }
    public ExtensionsNested<T> addNewExtension(){
    return new ExtensionsNestedImpl<T>();
    }
    public ExtensionsNested<T> addNewExtensionLike( NamedExtension item){
    return new ExtensionsNestedImpl<T>(item);
    }
    public String getPassword(){
    return this.password;
    }
    public T withPassword( String password){
    this.password=password; return (T) this;
    }
    public String getToken(){
    return this.token;
    }
    public T withToken( String token){
    this.token=token; return (T) this;
    }
    public String getUsername(){
    return this.username;
    }
    public T withUsername( String username){
    this.username=username; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
AuthInfoFluentImpl that = (AuthInfoFluentImpl) o;
if (clientCertificate != null ? !clientCertificate.equals(that.clientCertificate) :that.clientCertificate != null) return false;
if (clientCertificateData != null ? !clientCertificateData.equals(that.clientCertificateData) :that.clientCertificateData != null) return false;
if (clientKey != null ? !clientKey.equals(that.clientKey) :that.clientKey != null) return false;
if (clientKeyData != null ? !clientKeyData.equals(that.clientKeyData) :that.clientKeyData != null) return false;
if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
if (password != null ? !password.equals(that.password) :that.password != null) return false;
if (token != null ? !token.equals(that.token) :that.token != null) return false;
if (username != null ? !username.equals(that.username) :that.username != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ExtensionsNested<N>> implements ExtensionsNested<N>{

        private final NamedExtensionBuilder builder;
    
             ExtensionsNestedImpl ( NamedExtension item){
        this.builder = new NamedExtensionBuilder(this, item);
        }
             ExtensionsNestedImpl (){
        this.builder = new NamedExtensionBuilder(this);
        }
    
            public N and(){
            return (N) AuthInfoFluentImpl.this.addToExtensions(builder.build());
        }
            public N endExtension(){
            return and();
        }
    
}


}
