package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ContainerStatusFluentImpl<T extends ContainerStatusFluent<T>> extends BaseFluent<T> implements ContainerStatusFluent<T>{

     String containerID;     String image;     String imageID;     VisitableBuilder<ContainerState, ?> lastState;     String name;     Boolean ready;     Integer restartCount;     VisitableBuilder<ContainerState, ?> state;     Map<String, Object> additionalProperties = new HashMap();

    public String getContainerID(){
    return this.containerID;
    }
    public T withContainerID( String containerID){
    this.containerID=containerID; return (T) this;
    }
    public String getImage(){
    return this.image;
    }
    public T withImage( String image){
    this.image=image; return (T) this;
    }
    public String getImageID(){
    return this.imageID;
    }
    public T withImageID( String imageID){
    this.imageID=imageID; return (T) this;
    }
    public ContainerState getLastState(){
    return this.lastState!=null?this.lastState.build():null;
    }
    public T withLastState( ContainerState lastState){
    if (lastState!=null){ this.lastState= new ContainerStateBuilder(lastState); _visitables.add(this.lastState);} return (T) this;
    }
    public LastStateNested<T> withNewLastState(){
    return new LastStateNestedImpl<T>();
    }
    public LastStateNested<T> withNewLastStateLike( ContainerState item){
    return new LastStateNestedImpl<T>(item);
    }
    public LastStateNested<T> editLastState(){
    return withNewLastStateLike(getLastState());
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public Boolean isReady(){
    return this.ready;
    }
    public T withReady( Boolean ready){
    this.ready=ready; return (T) this;
    }
    public Integer getRestartCount(){
    return this.restartCount;
    }
    public T withRestartCount( Integer restartCount){
    this.restartCount=restartCount; return (T) this;
    }
    public ContainerState getState(){
    return this.state!=null?this.state.build():null;
    }
    public T withState( ContainerState state){
    if (state!=null){ this.state= new ContainerStateBuilder(state); _visitables.add(this.state);} return (T) this;
    }
    public StateNested<T> withNewState(){
    return new StateNestedImpl<T>();
    }
    public StateNested<T> withNewStateLike( ContainerState item){
    return new StateNestedImpl<T>(item);
    }
    public StateNested<T> editState(){
    return withNewStateLike(getState());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerStatusFluentImpl that = (ContainerStatusFluentImpl) o;
if (containerID != null ? !containerID.equals(that.containerID) :that.containerID != null) return false;
if (image != null ? !image.equals(that.image) :that.image != null) return false;
if (imageID != null ? !imageID.equals(that.imageID) :that.imageID != null) return false;
if (lastState != null ? !lastState.equals(that.lastState) :that.lastState != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (ready != null ? !ready.equals(that.ready) :that.ready != null) return false;
if (restartCount != null ? !restartCount.equals(that.restartCount) :that.restartCount != null) return false;
if (state != null ? !state.equals(that.state) :that.state != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class LastStateNestedImpl<N> extends ContainerStateFluentImpl<LastStateNested<N>> implements LastStateNested<N>{

        private final ContainerStateBuilder builder;
    
             LastStateNestedImpl (){
        this.builder = new ContainerStateBuilder(this);
        }
             LastStateNestedImpl ( ContainerState item){
        this.builder = new ContainerStateBuilder(this, item);
        }
    
            public N endLastState(){
            return and();
        }
            public N and(){
            return (N) ContainerStatusFluentImpl.this.withLastState(builder.build());
        }
    
}
    public class StateNestedImpl<N> extends ContainerStateFluentImpl<StateNested<N>> implements StateNested<N>{

        private final ContainerStateBuilder builder;
    
             StateNestedImpl (){
        this.builder = new ContainerStateBuilder(this);
        }
             StateNestedImpl ( ContainerState item){
        this.builder = new ContainerStateBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerStatusFluentImpl.this.withState(builder.build());
        }
            public N endState(){
            return and();
        }
    
}


}
