package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface EndpointsListFluent<T extends EndpointsListFluent<T>> extends Fluent<T>{


    public EndpointsList.ApiVersion getApiVersion();    public T withApiVersion( EndpointsList.ApiVersion apiVersion);    public T addToItems( Endpoints ...items);    public T removeFromItems( Endpoints ...items);    public List<Endpoints> getItems();    public T withItems( List<Endpoints> items);    public T withItems( Endpoints ...items);    public ItemsNested<T> addNewItem();    public ItemsNested<T> addNewItemLike( Endpoints item);    public String getKind();    public T withKind( String kind);    public ListMeta getMetadata();    public T withMetadata( ListMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ListMeta item);    public MetadataNested<T> editMetadata();    public T withNewMetadata( String resourceVersion,  String selfLink);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ItemsNested<N> extends Nested<N>, EndpointsFluent<ItemsNested<N>>{
            public N endItem();            public N and();        
}

    public interface MetadataNested<N> extends Nested<N>, ListMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
