package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface NodeStatusFluent<T extends NodeStatusFluent<T>> extends Fluent<T>{


    public T addToAddresses( NodeAddress ...items);    public T removeFromAddresses( NodeAddress ...items);    public List<NodeAddress> getAddresses();    public T withAddresses( List<NodeAddress> addresses);    public T withAddresses( NodeAddress ...addresses);    public AddressesNested<T> addNewAddresse();    public AddressesNested<T> addNewAddresseLike( NodeAddress item);    public T addNewAddresse( String address,  String type);    public T addToCapacity( String key,  Quantity value);    public T removeFromCapacity( String key);    public Map<String, Quantity> getCapacity();    public T withCapacity( Map<String, Quantity> capacity);    public T addToConditions( NodeCondition ...items);    public T removeFromConditions( NodeCondition ...items);    public List<NodeCondition> getConditions();    public T withConditions( List<NodeCondition> conditions);    public T withConditions( NodeCondition ...conditions);    public ConditionsNested<T> addNewCondition();    public ConditionsNested<T> addNewConditionLike( NodeCondition item);    public NodeSystemInfo getNodeInfo();    public T withNodeInfo( NodeSystemInfo nodeInfo);    public NodeInfoNested<T> withNewNodeInfo();    public NodeInfoNested<T> withNewNodeInfoLike( NodeSystemInfo item);    public NodeInfoNested<T> editNodeInfo();    public String getPhase();    public T withPhase( String phase);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface AddressesNested<N> extends Nested<N>, NodeAddressFluent<AddressesNested<N>>{
            public N and();            public N endAddresse();        
}

    public interface ConditionsNested<N> extends Nested<N>, NodeConditionFluent<ConditionsNested<N>>{
            public N endCondition();            public N and();        
}

    public interface NodeInfoNested<N> extends Nested<N>, NodeSystemInfoFluent<NodeInfoNested<N>>{
            public N and();            public N endNodeInfo();        
}


}
