package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface RBDVolumeSourceFluent<T extends RBDVolumeSourceFluent<T>> extends Fluent<T>{


    public String getFsType();    public T withFsType( String fsType);    public String getImage();    public T withImage( String image);    public String getKeyring();    public T withKeyring( String keyring);    public T addToMonitors( String ...items);    public T removeFromMonitors( String ...items);    public List<String> getMonitors();    public T withMonitors( List<String> monitors);    public T withMonitors( String ...monitors);    public String getPool();    public T withPool( String pool);    public Boolean isReadOnly();    public T withReadOnly( Boolean readOnly);    public LocalObjectReference getSecretRef();    public T withSecretRef( LocalObjectReference secretRef);    public SecretRefNested<T> withNewSecretRef();    public SecretRefNested<T> withNewSecretRefLike( LocalObjectReference item);    public SecretRefNested<T> editSecretRef();    public T withNewSecretRef( String name);    public String getUser();    public T withUser( String user);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface SecretRefNested<N> extends Nested<N>, LocalObjectReferenceFluent<SecretRefNested<N>>{
            public N endSecretRef();            public N and();        
}


}
