package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ServiceAccountListFluent<T extends ServiceAccountListFluent<T>> extends Fluent<T>{


    public ServiceAccountList.ApiVersion getApiVersion();    public T withApiVersion( ServiceAccountList.ApiVersion apiVersion);    public T addToItems( ServiceAccount ...items);    public T removeFromItems( ServiceAccount ...items);    public List<ServiceAccount> getItems();    public T withItems( List<ServiceAccount> items);    public T withItems( ServiceAccount ...items);    public ItemsNested<T> addNewItem();    public ItemsNested<T> addNewItemLike( ServiceAccount item);    public String getKind();    public T withKind( String kind);    public ListMeta getMetadata();    public T withMetadata( ListMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ListMeta item);    public MetadataNested<T> editMetadata();    public T withNewMetadata( String resourceVersion,  String selfLink);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ItemsNested<N> extends Nested<N>, ServiceAccountFluent<ItemsNested<N>>{
            public N endItem();            public N and();        
}

    public interface MetadataNested<N> extends Nested<N>, ListMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
