package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ServiceSpecFluent<T extends ServiceSpecFluent<T>> extends Fluent<T>{


    public String getClusterIP();    public T withClusterIP( String clusterIP);    public T addToDeprecatedPublicIPs( String ...items);    public T removeFromDeprecatedPublicIPs( String ...items);    public List<String> getDeprecatedPublicIPs();    public T withDeprecatedPublicIPs( List<String> deprecatedPublicIPs);    public T withDeprecatedPublicIPs( String ...deprecatedPublicIPs);    public String getPortalIP();    public T withPortalIP( String portalIP);    public T addToPorts( ServicePort ...items);    public T removeFromPorts( ServicePort ...items);    public List<ServicePort> getPorts();    public T withPorts( List<ServicePort> ports);    public T withPorts( ServicePort ...ports);    public PortsNested<T> addNewPort();    public PortsNested<T> addNewPortLike( ServicePort item);    public T addToSelector( String key,  String value);    public T removeFromSelector( String key);    public Map<String, String> getSelector();    public T withSelector( Map<String, String> selector);    public String getSessionAffinity();    public T withSessionAffinity( String sessionAffinity);    public String getType();    public T withType( String type);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface PortsNested<N> extends Nested<N>, ServicePortFluent<PortsNested<N>>{
            public N endPort();            public N and();        
}


}
