package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ClusterPolicyBindingFluent<T extends ClusterPolicyBindingFluent<T>> extends Fluent<T>{


    public ClusterPolicyBinding.ApiVersion getApiVersion();    public T withApiVersion( ClusterPolicyBinding.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public String getLastModified();    public T withLastModified( String lastModified);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public ObjectReference getPolicyRef();    public T withPolicyRef( ObjectReference policyRef);    public PolicyRefNested<T> withNewPolicyRef();    public PolicyRefNested<T> withNewPolicyRefLike( ObjectReference item);    public PolicyRefNested<T> editPolicyRef();    public T addToRoleBindings( NamedClusterRoleBinding ...items);    public T removeFromRoleBindings( NamedClusterRoleBinding ...items);    public List<NamedClusterRoleBinding> getRoleBindings();    public T withRoleBindings( List<NamedClusterRoleBinding> roleBindings);    public T withRoleBindings( NamedClusterRoleBinding ...roleBindings);    public RoleBindingsNested<T> addNewRoleBinding();    public RoleBindingsNested<T> addNewRoleBindingLike( NamedClusterRoleBinding item);    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface PolicyRefNested<N> extends Nested<N>, ObjectReferenceFluent<PolicyRefNested<N>>{
            public N endPolicyRef();            public N and();        
}

    public interface RoleBindingsNested<N> extends Nested<N>, NamedClusterRoleBindingFluent<RoleBindingsNested<N>>{
            public N endRoleBinding();            public N and();        
}


}
