package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface UserFluent<T extends UserFluent<T>> extends Fluent<T>{


    public User.ApiVersion getApiVersion();    public T withApiVersion( User.ApiVersion apiVersion);    public String getFullName();    public T withFullName( String fullName);    public T addToGroups( String ...items);    public T removeFromGroups( String ...items);    public List<String> getGroups();    public T withGroups( List<String> groups);    public T withGroups( String ...groups);    public T addToIdentities( String ...items);    public T removeFromIdentities( String ...items);    public List<String> getIdentities();    public T withIdentities( List<String> identities);    public T withIdentities( String ...identities);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToAdditionalProperties( String key,  Object value);    public T removeFromAdditionalProperties( String key);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
